/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsCallbackRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callbackId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public PatchConversationsCallbackRequest withCallbackId(String callbackId) {
        this.setCallbackId(callbackId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PatchConversationsCallbackRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsCallbackRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() {
        if (this.callbackId == null) {
            throw new IllegalStateException("Missing the required parameter 'callbackId' when building request for PatchConversationsCallbackRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallbackRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/callbacks/{callbackId}").withPathParameter("callbackId", this.callbackId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callbackId, Conversation body) {
        return new Builder().withRequiredParams(callbackId, body);
    }

    public static class Builder {
        private final PatchConversationsCallbackRequest request = new PatchConversationsCallbackRequest();

        private Builder() {
        }

        public Builder withCallbackId(String callbackId) {
            this.request.setCallbackId(callbackId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callbackId, Conversation body) {
            this.request.setCallbackId(callbackId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsCallbackRequest build() {
            return this.request;
        }
    }
}

