/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRole;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchAuthorizationRoleRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String roleId;
    private DomainOrganizationRole body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public PatchAuthorizationRoleRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public DomainOrganizationRole getBody() {
        return this.body;
    }

    public void setBody(DomainOrganizationRole body) {
        this.body = body;
    }

    public PatchAuthorizationRoleRequest withBody(DomainOrganizationRole body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchAuthorizationRoleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DomainOrganizationRole> withHttpInfo() {
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PatchAuthorizationRoleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchAuthorizationRoleRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/authorization/roles/{roleId}").withPathParameter("roleId", this.roleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleId, DomainOrganizationRole body) {
        return new Builder().withRequiredParams(roleId, body);
    }

    public static class Builder {
        private final PatchAuthorizationRoleRequest request = new PatchAuthorizationRoleRequest();

        private Builder() {
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withBody(DomainOrganizationRole body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roleId, DomainOrganizationRole body) {
            this.request.setRoleId(roleId);
            this.request.setBody(body);
            return this;
        }

        public PatchAuthorizationRoleRequest build() {
            return this.request;
        }
    }
}

