/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Activity Code")
public class CreateActivityCodeRequest
implements Serializable {
    private String name = null;
    private String category = null;
    private Integer lengthInMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsWorkTime = null;
    private Boolean agentTimeOffSelectable = null;

    public CreateActivityCodeRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the activity code")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateActivityCodeRequest category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity code's category")
    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public CreateActivityCodeRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The default length of the activity in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public CreateActivityCodeRequest countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether an agent is paid while performing this activity")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public CreateActivityCodeRequest countsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates whether or not the activity should be counted as work time")
    @JsonProperty(value="countsAsWorkTime")
    public Boolean getCountsAsWorkTime() {
        return this.countsAsWorkTime;
    }

    public void setCountsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
    }

    public CreateActivityCodeRequest agentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent can select this activity code when creating or editing a time off request")
    @JsonProperty(value="agentTimeOffSelectable")
    public Boolean getAgentTimeOffSelectable() {
        return this.agentTimeOffSelectable;
    }

    public void setAgentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActivityCodeRequest createActivityCodeRequest = (CreateActivityCodeRequest)o;
        return Objects.equals(this.name, createActivityCodeRequest.name) && Objects.equals(this.category, createActivityCodeRequest.category) && Objects.equals(this.lengthInMinutes, createActivityCodeRequest.lengthInMinutes) && Objects.equals(this.countsAsPaidTime, createActivityCodeRequest.countsAsPaidTime) && Objects.equals(this.countsAsWorkTime, createActivityCodeRequest.countsAsWorkTime) && Objects.equals(this.agentTimeOffSelectable, createActivityCodeRequest.agentTimeOffSelectable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.category, this.lengthInMinutes, this.countsAsPaidTime, this.countsAsWorkTime, this.agentTimeOffSelectable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateActivityCodeRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsWorkTime: ").append(this.toIndentedString(this.countsAsWorkTime)).append("\n");
        sb.append("    agentTimeOffSelectable: ").append(this.toIndentedString(this.agentTimeOffSelectable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

