/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WorkitemStatusReference;
import com.mypurecloud.sdk.v2.model.WorktypeReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkitemStatus
implements Serializable {
    private String id = null;
    private String name = null;
    private CategoryEnum category = null;
    private List<WorkitemStatusReference> destinationStatuses = null;
    private String description = null;
    private WorkitemStatusReference defaultDestinationStatus = null;
    private Integer statusTransitionDelaySeconds = null;
    private String statusTransitionTime = null;
    private WorktypeReference worktype = null;
    private Boolean autoTerminateWorkitem = null;
    private String selfUri = null;

    public WorkitemStatus() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.destinationStatuses = new ArrayList<WorkitemStatusReference>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WorkitemStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemStatus category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", value="The Category of the Status.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public WorkitemStatus destinationStatuses(List<WorkitemStatusReference> destinationStatuses) {
        this.destinationStatuses = destinationStatuses;
        return this;
    }

    @ApiModelProperty(example="null", value="The Statuses the Status can transition to.")
    @JsonProperty(value="destinationStatuses")
    public List<WorkitemStatusReference> getDestinationStatuses() {
        return this.destinationStatuses;
    }

    public void setDestinationStatuses(List<WorkitemStatusReference> destinationStatuses) {
        this.destinationStatuses = destinationStatuses;
    }

    public WorkitemStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Status.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemStatus defaultDestinationStatus(WorkitemStatusReference defaultDestinationStatus) {
        this.defaultDestinationStatus = defaultDestinationStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Default destination status to which this Status will transition to if auto status transition enabled.")
    @JsonProperty(value="defaultDestinationStatus")
    public WorkitemStatusReference getDefaultDestinationStatus() {
        return this.defaultDestinationStatus;
    }

    public void setDefaultDestinationStatus(WorkitemStatusReference defaultDestinationStatus) {
        this.defaultDestinationStatus = defaultDestinationStatus;
    }

    public WorkitemStatus statusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Delay in seconds for auto status transition")
    @JsonProperty(value="statusTransitionDelaySeconds")
    public Integer getStatusTransitionDelaySeconds() {
        return this.statusTransitionDelaySeconds;
    }

    public void setStatusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
    }

    public WorkitemStatus statusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time is represented as an ISO-8601 string without a timezone. For example: HH:mm:ss.SSS")
    @JsonProperty(value="statusTransitionTime")
    public String getStatusTransitionTime() {
        return this.statusTransitionTime;
    }

    public void setStatusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
    }

    public WorkitemStatus worktype(WorktypeReference worktype) {
        this.worktype = worktype;
        return this;
    }

    @ApiModelProperty(example="null", value="The Worktype containing the Status.")
    @JsonProperty(value="worktype")
    public WorktypeReference getWorktype() {
        return this.worktype;
    }

    public void setWorktype(WorktypeReference worktype) {
        this.worktype = worktype;
    }

    public WorkitemStatus autoTerminateWorkitem(Boolean autoTerminateWorkitem) {
        this.autoTerminateWorkitem = autoTerminateWorkitem;
        return this;
    }

    @ApiModelProperty(example="null", value="Terminate workitem on selection of status. Applicable only for statuses in the Closed category.")
    @JsonProperty(value="autoTerminateWorkitem")
    public Boolean getAutoTerminateWorkitem() {
        return this.autoTerminateWorkitem;
    }

    public void setAutoTerminateWorkitem(Boolean autoTerminateWorkitem) {
        this.autoTerminateWorkitem = autoTerminateWorkitem;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemStatus workitemStatus = (WorkitemStatus)o;
        return Objects.equals(this.id, workitemStatus.id) && Objects.equals(this.name, workitemStatus.name) && Objects.equals((Object)this.category, (Object)workitemStatus.category) && Objects.equals(this.destinationStatuses, workitemStatus.destinationStatuses) && Objects.equals(this.description, workitemStatus.description) && Objects.equals(this.defaultDestinationStatus, workitemStatus.defaultDestinationStatus) && Objects.equals(this.statusTransitionDelaySeconds, workitemStatus.statusTransitionDelaySeconds) && Objects.equals(this.statusTransitionTime, workitemStatus.statusTransitionTime) && Objects.equals(this.worktype, workitemStatus.worktype) && Objects.equals(this.autoTerminateWorkitem, workitemStatus.autoTerminateWorkitem) && Objects.equals(this.selfUri, workitemStatus.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.category, this.destinationStatuses, this.description, this.defaultDestinationStatus, this.statusTransitionDelaySeconds, this.statusTransitionTime, this.worktype, this.autoTerminateWorkitem, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    destinationStatuses: ").append(this.toIndentedString(this.destinationStatuses)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultDestinationStatus: ").append(this.toIndentedString(this.defaultDestinationStatus)).append("\n");
        sb.append("    statusTransitionDelaySeconds: ").append(this.toIndentedString(this.statusTransitionDelaySeconds)).append("\n");
        sb.append("    statusTransitionTime: ").append(this.toIndentedString(this.statusTransitionTime)).append("\n");
        sb.append("    worktype: ").append(this.toIndentedString(this.worktype)).append("\n");
        sb.append("    autoTerminateWorkitem: ").append(this.toIndentedString(this.autoTerminateWorkitem)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open"),
        INPROGRESS("InProgress"),
        WAITING("Waiting"),
        CLOSED("Closed"),
        UNKNOWN("Unknown");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

