/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Browser;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.Device;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.JourneyPage;
import com.mypurecloud.sdk.v2.model.Referrer;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class WebEvent
implements Serializable {
    private String eventName = null;
    private Integer totalEventCount = null;
    private Integer totalPageviewCount = null;
    private JourneyPage page = null;
    private String userAgentString = null;
    private Browser browser = null;
    private Device device = null;
    private JourneyGeolocation geolocation = null;
    private String ipAddress = null;
    private String ipOrganization = null;
    private JourneyCampaign mktCampaign = null;
    private Referrer referrer = null;
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttribute> traits = null;
    private String searchQuery = null;
    private Boolean authenticated = null;

    public WebEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public WebEvent eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Represents the action the customer performed. A good event name is typically an object followed by the action performed in past tense (e.g. page_viewed, order_completed, user_registered).")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public WebEvent totalEventCount(Integer totalEventCount) {
        this.totalEventCount = totalEventCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The total count of events performed by the customer across all sessions.")
    @JsonProperty(value="totalEventCount")
    public Integer getTotalEventCount() {
        return this.totalEventCount;
    }

    public void setTotalEventCount(Integer totalEventCount) {
        this.totalEventCount = totalEventCount;
    }

    public WebEvent totalPageviewCount(Integer totalPageviewCount) {
        this.totalPageviewCount = totalPageviewCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The total count of pageviews performed by the customer across all sessions.")
    @JsonProperty(value="totalPageviewCount")
    public Integer getTotalPageviewCount() {
        return this.totalPageviewCount;
    }

    public void setTotalPageviewCount(Integer totalPageviewCount) {
        this.totalPageviewCount = totalPageviewCount;
    }

    public WebEvent page(JourneyPage page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The webpage where the user interaction occurred.")
    @JsonProperty(value="page")
    public JourneyPage getPage() {
        return this.page;
    }

    public void setPage(JourneyPage page) {
        this.page = page;
    }

    public WebEvent userAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).")
    @JsonProperty(value="userAgentString")
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public WebEvent browser(Browser browser) {
        this.browser = browser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's browser.")
    @JsonProperty(value="browser")
    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public WebEvent device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's device.")
    @JsonProperty(value="device")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public WebEvent geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public WebEvent ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP address. May be null if the business configures the tracker to not collect IP addresses.")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public WebEvent ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public WebEvent mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Marketing / traffic source information.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public WebEvent referrer(Referrer referrer) {
        this.referrer = referrer;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the page URL that originally generated the request for the current page being viewed.")
    @JsonProperty(value="referrer")
    public Referrer getReferrer() {
        return this.referrer;
    }

    public void setReferrer(Referrer referrer) {
        this.referrer = referrer;
    }

    public WebEvent attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined attributes associated with a particular event.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public WebEvent traits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined traits associated with a particular event.")
    @JsonProperty(value="traits")
    public Map<String, CustomEventAttribute> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
    }

    public WebEvent searchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the keywords in a customer search query.")
    @JsonProperty(value="searchQuery")
    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public WebEvent authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates whether the event was produced during an authenticated session.")
    @JsonProperty(value="authenticated")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebEvent webEvent = (WebEvent)o;
        return Objects.equals(this.eventName, webEvent.eventName) && Objects.equals(this.totalEventCount, webEvent.totalEventCount) && Objects.equals(this.totalPageviewCount, webEvent.totalPageviewCount) && Objects.equals(this.page, webEvent.page) && Objects.equals(this.userAgentString, webEvent.userAgentString) && Objects.equals(this.browser, webEvent.browser) && Objects.equals(this.device, webEvent.device) && Objects.equals(this.geolocation, webEvent.geolocation) && Objects.equals(this.ipAddress, webEvent.ipAddress) && Objects.equals(this.ipOrganization, webEvent.ipOrganization) && Objects.equals(this.mktCampaign, webEvent.mktCampaign) && Objects.equals(this.referrer, webEvent.referrer) && Objects.equals(this.attributes, webEvent.attributes) && Objects.equals(this.traits, webEvent.traits) && Objects.equals(this.searchQuery, webEvent.searchQuery) && Objects.equals(this.authenticated, webEvent.authenticated);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.totalEventCount, this.totalPageviewCount, this.page, this.userAgentString, this.browser, this.device, this.geolocation, this.ipAddress, this.ipOrganization, this.mktCampaign, this.referrer, this.attributes, this.traits, this.searchQuery, this.authenticated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebEvent {\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    totalEventCount: ").append(this.toIndentedString(this.totalEventCount)).append("\n");
        sb.append("    totalPageviewCount: ").append(this.toIndentedString(this.totalPageviewCount)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    userAgentString: ").append(this.toIndentedString(this.userAgentString)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    referrer: ").append(this.toIndentedString(this.referrer)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    searchQuery: ").append(this.toIndentedString(this.searchQuery)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

