/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.OrgUser;
import com.mypurecloud.sdk.v2.model.Organization;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Trustee
implements Serializable {
    private String id = null;
    private Boolean enabled = null;
    private Boolean usesDefaultRole = null;
    private Boolean hasFullAccess = null;
    private Boolean isTrustedUser = null;
    private Date dateCreated = null;
    private Date dateExpired = null;
    private OrgUser createdBy = null;
    private Organization organization = null;
    private String selfUri = null;

    public Trustee() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Organization Id for this trust.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Trustee enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If disabled no trustee user will have access, even if they were previously added.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Trustee usesDefaultRole(Boolean usesDefaultRole) {
        this.usesDefaultRole = usesDefaultRole;
        return this;
    }

    @ApiModelProperty(example="null", value="Denotes if trustee uses admin role by default.")
    @JsonProperty(value="usesDefaultRole")
    public Boolean getUsesDefaultRole() {
        return this.usesDefaultRole;
    }

    public void setUsesDefaultRole(Boolean usesDefaultRole) {
        this.usesDefaultRole = usesDefaultRole;
    }

    public Trustee hasFullAccess(Boolean hasFullAccess) {
        this.hasFullAccess = hasFullAccess;
        return this;
    }

    @ApiModelProperty(example="null", value="Denotes if trustee uses full access role by default.")
    @JsonProperty(value="hasFullAccess")
    public Boolean getHasFullAccess() {
        return this.hasFullAccess;
    }

    public void setHasFullAccess(Boolean hasFullAccess) {
        this.hasFullAccess = hasFullAccess;
    }

    public Trustee isTrustedUser(Boolean isTrustedUser) {
        this.isTrustedUser = isTrustedUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Denotes if trustee is given Trusted User access by default.")
    @JsonProperty(value="isTrustedUser")
    public Boolean getIsTrustedUser() {
        return this.isTrustedUser;
    }

    public void setIsTrustedUser(Boolean isTrustedUser) {
        this.isTrustedUser = isTrustedUser;
    }

    @ApiModelProperty(example="null", value="Date Trust was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Trustee dateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiration date of the trust. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpired")
    public Date getDateExpired() {
        return this.dateExpired;
    }

    public void setDateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
    }

    @ApiModelProperty(example="null", value="User that created trust.")
    @JsonProperty(value="createdBy")
    public OrgUser getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="Organization associated with this trust.")
    @JsonProperty(value="organization")
    public Organization getOrganization() {
        return this.organization;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trustee trustee = (Trustee)o;
        return Objects.equals(this.id, trustee.id) && Objects.equals(this.enabled, trustee.enabled) && Objects.equals(this.usesDefaultRole, trustee.usesDefaultRole) && Objects.equals(this.hasFullAccess, trustee.hasFullAccess) && Objects.equals(this.isTrustedUser, trustee.isTrustedUser) && Objects.equals(this.dateCreated, trustee.dateCreated) && Objects.equals(this.dateExpired, trustee.dateExpired) && Objects.equals(this.createdBy, trustee.createdBy) && Objects.equals(this.organization, trustee.organization) && Objects.equals(this.selfUri, trustee.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.enabled, this.usesDefaultRole, this.hasFullAccess, this.isTrustedUser, this.dateCreated, this.dateExpired, this.createdBy, this.organization, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trustee {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    usesDefaultRole: ").append(this.toIndentedString(this.usesDefaultRole)).append("\n");
        sb.append("    hasFullAccess: ").append(this.toIndentedString(this.hasFullAccess)).append("\n");
        sb.append("    isTrustedUser: ").append(this.toIndentedString(this.isTrustedUser)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateExpired: ").append(this.toIndentedString(this.dateExpired)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

