/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TranscriptionConfig
implements Serializable {
    private VendorNameEnum vendorName = null;

    public TranscriptionConfig() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TranscriptionConfig vendorName(VendorNameEnum vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the vendor used for speech transcription.")
    @JsonProperty(value="vendorName")
    public VendorNameEnum getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(VendorNameEnum vendorName) {
        this.vendorName = vendorName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranscriptionConfig transcriptionConfig = (TranscriptionConfig)o;
        return Objects.equals((Object)this.vendorName, (Object)transcriptionConfig.vendorName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendorName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TranscriptionConfig {\n");
        sb.append("    vendorName: ").append(this.toIndentedString((Object)this.vendorName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VendorNameEnumDeserializer.class)
    public static enum VendorNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GOOGLEDIALOGFLOW("GoogleDialogflow"),
        UNKNOWN("Unknown"),
        GENESYS("Genesys");

        private String value;

        private VendorNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VendorNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VendorNameEnum value : VendorNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VendorNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VendorNameEnumDeserializer
    extends StdDeserializer<VendorNameEnum> {
        public VendorNameEnumDeserializer() {
            super(VendorNameEnumDeserializer.class);
        }

        public VendorNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VendorNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

