/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StaffingGroupAllocation
implements Serializable {
    private String staffingGroupId = null;
    private List<Double> shrinkagePercentages = null;
    private List<Double> attritionPercentages = null;
    private List<Double> newHiresFullTimeEquivalentCount = null;
    private Double startingWeeklyFullTimeEquivalentCount = null;
    private List<String> planningGroupIds = null;

    public StaffingGroupAllocation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.shrinkagePercentages = new ArrayList<Double>();
            this.attritionPercentages = new ArrayList<Double>();
            this.newHiresFullTimeEquivalentCount = new ArrayList<Double>();
            this.planningGroupIds = new ArrayList<String>();
        }
    }

    public StaffingGroupAllocation staffingGroupId(String staffingGroupId) {
        this.staffingGroupId = staffingGroupId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The staffing group to which the result allocation belongs")
    @JsonProperty(value="staffingGroupId")
    public String getStaffingGroupId() {
        return this.staffingGroupId;
    }

    public void setStaffingGroupId(String staffingGroupId) {
        this.staffingGroupId = staffingGroupId;
    }

    public StaffingGroupAllocation shrinkagePercentages(List<Double> shrinkagePercentages) {
        this.shrinkagePercentages = shrinkagePercentages;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekly projected shrinkage percentage of staffing group, in the scale of 0 - 100")
    @JsonProperty(value="shrinkagePercentages")
    public List<Double> getShrinkagePercentages() {
        return this.shrinkagePercentages;
    }

    public void setShrinkagePercentages(List<Double> shrinkagePercentages) {
        this.shrinkagePercentages = shrinkagePercentages;
    }

    public StaffingGroupAllocation attritionPercentages(List<Double> attritionPercentages) {
        this.attritionPercentages = attritionPercentages;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekly projected attrition percentage of the staffing group, in the scale of 0 - 100")
    @JsonProperty(value="attritionPercentages")
    public List<Double> getAttritionPercentages() {
        return this.attritionPercentages;
    }

    public void setAttritionPercentages(List<Double> attritionPercentages) {
        this.attritionPercentages = attritionPercentages;
    }

    public StaffingGroupAllocation newHiresFullTimeEquivalentCount(List<Double> newHiresFullTimeEquivalentCount) {
        this.newHiresFullTimeEquivalentCount = newHiresFullTimeEquivalentCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The weekly projected full time equivalent agents of new hire agents added to the staffing group")
    @JsonProperty(value="newHiresFullTimeEquivalentCount")
    public List<Double> getNewHiresFullTimeEquivalentCount() {
        return this.newHiresFullTimeEquivalentCount;
    }

    public void setNewHiresFullTimeEquivalentCount(List<Double> newHiresFullTimeEquivalentCount) {
        this.newHiresFullTimeEquivalentCount = newHiresFullTimeEquivalentCount;
    }

    public StaffingGroupAllocation startingWeeklyFullTimeEquivalentCount(Double startingWeeklyFullTimeEquivalentCount) {
        this.startingWeeklyFullTimeEquivalentCount = startingWeeklyFullTimeEquivalentCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekly count of full time equivalent agents that can be used for the first week of the capacity plan")
    @JsonProperty(value="startingWeeklyFullTimeEquivalentCount")
    public Double getStartingWeeklyFullTimeEquivalentCount() {
        return this.startingWeeklyFullTimeEquivalentCount;
    }

    public void setStartingWeeklyFullTimeEquivalentCount(Double startingWeeklyFullTimeEquivalentCount) {
        this.startingWeeklyFullTimeEquivalentCount = startingWeeklyFullTimeEquivalentCount;
    }

    public StaffingGroupAllocation planningGroupIds(List<String> planningGroupIds) {
        this.planningGroupIds = planningGroupIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the planning groups associated with this staffing group")
    @JsonProperty(value="planningGroupIds")
    public List<String> getPlanningGroupIds() {
        return this.planningGroupIds;
    }

    public void setPlanningGroupIds(List<String> planningGroupIds) {
        this.planningGroupIds = planningGroupIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaffingGroupAllocation staffingGroupAllocation = (StaffingGroupAllocation)o;
        return Objects.equals(this.staffingGroupId, staffingGroupAllocation.staffingGroupId) && Objects.equals(this.shrinkagePercentages, staffingGroupAllocation.shrinkagePercentages) && Objects.equals(this.attritionPercentages, staffingGroupAllocation.attritionPercentages) && Objects.equals(this.newHiresFullTimeEquivalentCount, staffingGroupAllocation.newHiresFullTimeEquivalentCount) && Objects.equals(this.startingWeeklyFullTimeEquivalentCount, staffingGroupAllocation.startingWeeklyFullTimeEquivalentCount) && Objects.equals(this.planningGroupIds, staffingGroupAllocation.planningGroupIds);
    }

    public int hashCode() {
        return Objects.hash(this.staffingGroupId, this.shrinkagePercentages, this.attritionPercentages, this.newHiresFullTimeEquivalentCount, this.startingWeeklyFullTimeEquivalentCount, this.planningGroupIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StaffingGroupAllocation {\n");
        sb.append("    staffingGroupId: ").append(this.toIndentedString(this.staffingGroupId)).append("\n");
        sb.append("    shrinkagePercentages: ").append(this.toIndentedString(this.shrinkagePercentages)).append("\n");
        sb.append("    attritionPercentages: ").append(this.toIndentedString(this.attritionPercentages)).append("\n");
        sb.append("    newHiresFullTimeEquivalentCount: ").append(this.toIndentedString(this.newHiresFullTimeEquivalentCount)).append("\n");
        sb.append("    startingWeeklyFullTimeEquivalentCount: ").append(this.toIndentedString(this.startingWeeklyFullTimeEquivalentCount)).append("\n");
        sb.append("    planningGroupIds: ").append(this.toIndentedString(this.planningGroupIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

