/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SourceLastSync
implements Serializable {
    private StateEnum state = null;
    private Date dateStarted = null;
    private Date dateEnded = null;
    private ErrorBody error = null;

    public SourceLastSync() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SourceLastSync state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the last synchronization.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SourceLastSync dateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
        return this;
    }

    @ApiModelProperty(example="null", value="Last synchronization start-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStarted")
    public Date getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    public SourceLastSync dateEnded(Date dateEnded) {
        this.dateEnded = dateEnded;
        return this;
    }

    @ApiModelProperty(example="null", value="Last synchronization end-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnded")
    public Date getDateEnded() {
        return this.dateEnded;
    }

    public void setDateEnded(Date dateEnded) {
        this.dateEnded = dateEnded;
    }

    public SourceLastSync error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional error message of the last synchronization.")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLastSync sourceLastSync = (SourceLastSync)o;
        return Objects.equals((Object)this.state, (Object)sourceLastSync.state) && Objects.equals(this.dateStarted, sourceLastSync.dateStarted) && Objects.equals(this.dateEnded, sourceLastSync.dateEnded) && Objects.equals(this.error, sourceLastSync.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.dateStarted, this.dateEnded, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceLastSync {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateStarted: ").append(this.toIndentedString(this.dateStarted)).append("\n");
        sb.append("    dateEnded: ").append(this.toIndentedString(this.dateEnded)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("Success"),
        FAILED("Failed"),
        INPROGRESS("InProgress"),
        UNKNOWN("Unknown");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

