/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ScimEmail;
import com.mypurecloud.sdk.v2.model.ScimPhoneNumber;
import com.mypurecloud.sdk.v2.model.ScimUserExtensions;
import com.mypurecloud.sdk.v2.model.ScimUserRole;
import com.mypurecloud.sdk.v2.model.ScimV2EnterpriseUser;
import com.mypurecloud.sdk.v2.model.ScimV2GroupReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the creation of a SCIM user.")
public class ScimV2CreateUser
implements Serializable {
    private List<String> schemas = null;
    private Boolean active = null;
    private String userName = null;
    private String displayName = null;
    private String password = null;
    private String title = null;
    private List<ScimPhoneNumber> phoneNumbers = null;
    private List<ScimEmail> emails = null;
    private String externalId = null;
    private List<ScimV2GroupReference> groups = null;
    private List<ScimUserRole> roles = null;
    private ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User = null;
    private ScimUserExtensions urnietfparamsscimschemasextensiongenesyspurecloud20User = null;

    public ScimV2CreateUser() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.schemas = new ArrayList<String>();
            this.phoneNumbers = new ArrayList<ScimPhoneNumber>();
            this.emails = new ArrayList<ScimEmail>();
            this.groups = new ArrayList<ScimV2GroupReference>();
            this.roles = new ArrayList<ScimUserRole>();
        }
    }

    @ApiModelProperty(example="null", value="The list of supported schemas.")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public ScimV2CreateUser active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the user's administrative status is active.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ScimV2CreateUser userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user's Genesys Cloud email address. Must be unique.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ScimV2CreateUser displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The display name of the user.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ScimV2CreateUser password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="The new password for the Genesys Cloud user. Does not return an existing password. When creating a user, if a password is not supplied, then a password will be randomly generated that is 40 characters in length and contains five characters from each of the password policy groups.")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ScimV2CreateUser title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScimV2CreateUser phoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the user's phone numbers.")
    @JsonProperty(value="phoneNumbers")
    public List<ScimPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ScimV2CreateUser emails(List<ScimEmail> emails) {
        this.emails = emails;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the user's email addresses.")
    @JsonProperty(value="emails")
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ScimEmail> emails) {
        this.emails = emails;
    }

    public ScimV2CreateUser externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external ID of the user. Set by the provisioning client. \"caseExact\" is set to \"true\". \"mutability\" is set to \"readWrite\".")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @ApiModelProperty(example="null", value="The list of groups that the user is a member of. This list is immutable per SCIM RFC and may only be updated using the GROUPS resource endpoint.")
    @JsonProperty(value="groups")
    public List<ScimV2GroupReference> getGroups() {
        return this.groups;
    }

    public ScimV2CreateUser roles(List<ScimUserRole> roles) {
        this.roles = roles;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of roles assigned to the user.")
    @JsonProperty(value="roles")
    public List<ScimUserRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ScimUserRole> roles) {
        this.roles = roles;
    }

    public ScimV2CreateUser urnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the schema for the enterprise user.")
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    public ScimV2EnterpriseUser getUrnietfparamsscimschemasextensionenterprise20User() {
        return this.urnietfparamsscimschemasextensionenterprise20User;
    }

    public void setUrnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
    }

    public ScimV2CreateUser urnietfparamsscimschemasextensiongenesyspurecloud20User(ScimUserExtensions urnietfparamsscimschemasextensiongenesyspurecloud20User) {
        this.urnietfparamsscimschemasextensiongenesyspurecloud20User = urnietfparamsscimschemasextensiongenesyspurecloud20User;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the schema for the Genesys Cloud user.")
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User")
    public ScimUserExtensions getUrnietfparamsscimschemasextensiongenesyspurecloud20User() {
        return this.urnietfparamsscimschemasextensiongenesyspurecloud20User;
    }

    public void setUrnietfparamsscimschemasextensiongenesyspurecloud20User(ScimUserExtensions urnietfparamsscimschemasextensiongenesyspurecloud20User) {
        this.urnietfparamsscimschemasextensiongenesyspurecloud20User = urnietfparamsscimschemasextensiongenesyspurecloud20User;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2CreateUser scimV2CreateUser = (ScimV2CreateUser)o;
        return Objects.equals(this.schemas, scimV2CreateUser.schemas) && Objects.equals(this.active, scimV2CreateUser.active) && Objects.equals(this.userName, scimV2CreateUser.userName) && Objects.equals(this.displayName, scimV2CreateUser.displayName) && Objects.equals(this.password, scimV2CreateUser.password) && Objects.equals(this.title, scimV2CreateUser.title) && Objects.equals(this.phoneNumbers, scimV2CreateUser.phoneNumbers) && Objects.equals(this.emails, scimV2CreateUser.emails) && Objects.equals(this.externalId, scimV2CreateUser.externalId) && Objects.equals(this.groups, scimV2CreateUser.groups) && Objects.equals(this.roles, scimV2CreateUser.roles) && Objects.equals(this.urnietfparamsscimschemasextensionenterprise20User, scimV2CreateUser.urnietfparamsscimschemasextensionenterprise20User) && Objects.equals(this.urnietfparamsscimschemasextensiongenesyspurecloud20User, scimV2CreateUser.urnietfparamsscimschemasextensiongenesyspurecloud20User);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.active, this.userName, this.displayName, this.password, this.title, this.phoneNumbers, this.emails, this.externalId, this.groups, this.roles, this.urnietfparamsscimschemasextensionenterprise20User, this.urnietfparamsscimschemasextensiongenesyspurecloud20User);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2CreateUser {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    urnietfparamsscimschemasextensionenterprise20User: ").append(this.toIndentedString(this.urnietfparamsscimschemasextensionenterprise20User)).append("\n");
        sb.append("    urnietfparamsscimschemasextensiongenesyspurecloud20User: ").append(this.toIndentedString(this.urnietfparamsscimschemasextensiongenesyspurecloud20User)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

