/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ResponseAssetFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResponseAssetSearchRequest
implements Serializable {
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private SortOrderEnum sortOrder = null;
    private String sortBy = null;
    private List<ResponseAssetFilter> query = null;

    public ResponseAssetSearchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.query = new ArrayList<ResponseAssetFilter>();
        }
    }

    public ResponseAssetSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page. Default: 25, Maximum: 100.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ResponseAssetSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page of resources you want to retrieve")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ResponseAssetSearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ResponseAssetSearchRequest sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the resource that you want to sort the results by")
    @JsonProperty(value="sortBy")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public ResponseAssetSearchRequest query(List<ResponseAssetFilter> query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filter the query results.")
    @JsonProperty(value="query")
    public List<ResponseAssetFilter> getQuery() {
        return this.query;
    }

    public void setQuery(List<ResponseAssetFilter> query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseAssetSearchRequest responseAssetSearchRequest = (ResponseAssetSearchRequest)o;
        return Objects.equals(this.pageSize, responseAssetSearchRequest.pageSize) && Objects.equals(this.pageNumber, responseAssetSearchRequest.pageNumber) && Objects.equals((Object)this.sortOrder, (Object)responseAssetSearchRequest.sortOrder) && Objects.equals(this.sortBy, responseAssetSearchRequest.sortBy) && Objects.equals(this.query, responseAssetSearchRequest.query);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.pageNumber, this.sortOrder, this.sortBy, this.query});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseAssetSearchRequest {\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

