/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OverallBestPointsItem
implements Serializable {
    private GranularityTypeEnum granularityType = null;
    private List<UserReference> users = null;
    private Integer count = null;
    private Integer points = null;
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;

    public OverallBestPointsItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.users = new ArrayList<UserReference>();
        }
    }

    @ApiModelProperty(example="null", value="Best points aggregation interval granularity")
    @JsonProperty(value="granularityType")
    public GranularityTypeEnum getGranularityType() {
        return this.granularityType;
    }

    @ApiModelProperty(example="null", value="List of associated users with the equal points.")
    @JsonProperty(value="users")
    public List<UserReference> getUsers() {
        return this.users;
    }

    @ApiModelProperty(example="null", value="The count of the user IDs in the list")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    @ApiModelProperty(example="null", value="Gamification points")
    @JsonProperty(value="points")
    public Integer getPoints() {
        return this.points;
    }

    @ApiModelProperty(example="null", value="Start workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    @ApiModelProperty(example="null", value="End workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverallBestPointsItem overallBestPointsItem = (OverallBestPointsItem)o;
        return Objects.equals((Object)this.granularityType, (Object)overallBestPointsItem.granularityType) && Objects.equals(this.users, overallBestPointsItem.users) && Objects.equals(this.count, overallBestPointsItem.count) && Objects.equals(this.points, overallBestPointsItem.points) && Objects.equals(this.dateStartWorkday, overallBestPointsItem.dateStartWorkday) && Objects.equals(this.dateEndWorkday, overallBestPointsItem.dateEndWorkday);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.granularityType, this.users, this.count, this.points, this.dateStartWorkday, this.dateEndWorkday});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverallBestPointsItem {\n");
        sb.append("    granularityType: ").append(this.toIndentedString((Object)this.granularityType)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityTypeEnumDeserializer.class)
    public static enum GranularityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        private String value;

        private GranularityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityTypeEnum value : GranularityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityTypeEnumDeserializer
    extends StdDeserializer<GranularityTypeEnum> {
        public GranularityTypeEnumDeserializer() {
            super(GranularityTypeEnumDeserializer.class);
        }

        public GranularityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

