/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BotEntityValue;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.ReplyMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Outgoing Message request")
public class OutgoingMessageRequest
implements Serializable {
    private String botId = null;
    private String botVersion = null;
    private String botSessionId = null;
    private BotStateEnum botState = null;
    private String languageCode = null;
    private List<ReplyMessage> replyMessages = null;
    private String intent = null;
    private Double confidence = null;
    private ErrorInfo errorInfo = null;
    private Map<String, String> parameters = null;
    private List<BotEntityValue> entities = null;

    public OutgoingMessageRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.replyMessages = new ArrayList<ReplyMessage>();
            this.entities = new ArrayList<BotEntityValue>();
        }
    }

    public OutgoingMessageRequest botId(String botId) {
        this.botId = botId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unique id of the bot.")
    @JsonProperty(value="botId")
    public String getBotId() {
        return this.botId;
    }

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public OutgoingMessageRequest botVersion(String botVersion) {
        this.botVersion = botVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the bot.")
    @JsonProperty(value="botVersion")
    public String getBotVersion() {
        return this.botVersion;
    }

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public OutgoingMessageRequest botSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).")
    @JsonProperty(value="botSessionId")
    public String getBotSessionId() {
        return this.botSessionId;
    }

    public void setBotSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
    }

    public OutgoingMessageRequest botState(BotStateEnum botState) {
        this.botState = botState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the bot reported")
    @JsonProperty(value="botState")
    public BotStateEnum getBotState() {
        return this.botState;
    }

    public void setBotState(BotStateEnum botState) {
        this.botState = botState;
    }

    public OutgoingMessageRequest languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The language used for this message. EG 'en-us' or 'es', etc; These language codes are W3C language identification tags (ISO 639-1 for the language name and ISO 3166 for the country code).")
    @JsonProperty(value="languageCode")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public OutgoingMessageRequest replyMessages(List<ReplyMessage> replyMessages) {
        this.replyMessages = replyMessages;
        return this;
    }

    @ApiModelProperty(example="null", value="This is a list of messages to send back to the user, this field can be null or an empty list.")
    @JsonProperty(value="replyMessages")
    public List<ReplyMessage> getReplyMessages() {
        return this.replyMessages;
    }

    public void setReplyMessages(List<ReplyMessage> replyMessages) {
        this.replyMessages = replyMessages;
    }

    public OutgoingMessageRequest intent(String intent) {
        this.intent = intent;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the intent the bot is either processing or has processed, this will be blank if no intent could be detected.")
    @JsonProperty(value="intent")
    public String getIntent() {
        return this.intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public OutgoingMessageRequest confidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    @ApiModelProperty(example="null", value="A value between 0 and 1.0 denoting the confidence of the discovered intent (if found) this is optional and if left null genesys assumes a confidence of 1.0 on success and 0 on fail.")
    @JsonProperty(value="confidence")
    public Double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Double confidence) {
        this.confidence = confidence;
    }

    public OutgoingMessageRequest errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the botState is Failed the bot can add this error object with more details about the error.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public OutgoingMessageRequest parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", value="This is a map of string-string key, value pairs containing optional fields that can be passed from the bot for custom behavior, tracking, etc, which can be used by the flow.")
    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public OutgoingMessageRequest entities(List<BotEntityValue> entities) {
        this.entities = entities;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of entity values that go along with the intent.")
    @JsonProperty(value="entities")
    public List<BotEntityValue> getEntities() {
        return this.entities;
    }

    public void setEntities(List<BotEntityValue> entities) {
        this.entities = entities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutgoingMessageRequest outgoingMessageRequest = (OutgoingMessageRequest)o;
        return Objects.equals(this.botId, outgoingMessageRequest.botId) && Objects.equals(this.botVersion, outgoingMessageRequest.botVersion) && Objects.equals(this.botSessionId, outgoingMessageRequest.botSessionId) && Objects.equals((Object)this.botState, (Object)outgoingMessageRequest.botState) && Objects.equals(this.languageCode, outgoingMessageRequest.languageCode) && Objects.equals(this.replyMessages, outgoingMessageRequest.replyMessages) && Objects.equals(this.intent, outgoingMessageRequest.intent) && Objects.equals(this.confidence, outgoingMessageRequest.confidence) && Objects.equals(this.errorInfo, outgoingMessageRequest.errorInfo) && Objects.equals(this.parameters, outgoingMessageRequest.parameters) && Objects.equals(this.entities, outgoingMessageRequest.entities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.botId, this.botVersion, this.botSessionId, this.botState, this.languageCode, this.replyMessages, this.intent, this.confidence, this.errorInfo, this.parameters, this.entities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutgoingMessageRequest {\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("    botVersion: ").append(this.toIndentedString(this.botVersion)).append("\n");
        sb.append("    botSessionId: ").append(this.toIndentedString(this.botSessionId)).append("\n");
        sb.append("    botState: ").append(this.toIndentedString((Object)this.botState)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    replyMessages: ").append(this.toIndentedString(this.replyMessages)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("    confidence: ").append(this.toIndentedString(this.confidence)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BotStateEnumDeserializer.class)
    public static enum BotStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETE("Complete"),
        FAILED("Failed"),
        MOREDATA("MoreData");

        private String value;

        private BotStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotStateEnum value : BotStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BotStateEnumDeserializer
    extends StdDeserializer<BotStateEnum> {
        public BotStateEnumDeserializer() {
            super(BotStateEnumDeserializer.class);
        }

        public BotStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BotStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

