/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class OrphanUpdateRequest
implements Serializable {
    private Date archiveDate = null;
    private Date deleteDate = null;
    private Date exportDate = null;
    private String integrationId = null;
    private String conversationId = null;

    public OrphanUpdateRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OrphanUpdateRequest archiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The orphan recording's archive date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="archiveDate")
    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public OrphanUpdateRequest deleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The orphan recording's delete date. Must be greater than archiveDate and exportDate if set, otherwise one day from now. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="deleteDate")
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public OrphanUpdateRequest exportDate(Date exportDate) {
        this.exportDate = exportDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The orphan recording's export date. Must be greater than 1 day from now if set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportDate")
    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date exportDate) {
        this.exportDate = exportDate;
    }

    public OrphanUpdateRequest integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="IntegrationId to access AWS S3 bucket for export. This field is required if exportDate is set.")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public OrphanUpdateRequest conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="A conversation Id that this orphan's recording is to be attached to. If not present, the conversationId will be deduced from the recording media.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrphanUpdateRequest orphanUpdateRequest = (OrphanUpdateRequest)o;
        return Objects.equals(this.archiveDate, orphanUpdateRequest.archiveDate) && Objects.equals(this.deleteDate, orphanUpdateRequest.deleteDate) && Objects.equals(this.exportDate, orphanUpdateRequest.exportDate) && Objects.equals(this.integrationId, orphanUpdateRequest.integrationId) && Objects.equals(this.conversationId, orphanUpdateRequest.conversationId);
    }

    public int hashCode() {
        return Objects.hash(this.archiveDate, this.deleteDate, this.exportDate, this.integrationId, this.conversationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrphanUpdateRequest {\n");
        sb.append("    archiveDate: ").append(this.toIndentedString(this.archiveDate)).append("\n");
        sb.append("    deleteDate: ").append(this.toIndentedString(this.deleteDate)).append("\n");
        sb.append("    exportDate: ").append(this.toIndentedString(this.exportDate)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

