/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import com.mypurecloud.sdk.v2.model.RoleDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class OrgOAuthClient
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private AuthorizedGrantTypeEnum authorizedGrantType = null;
    private List<String> scope = null;
    private List<RoleDivision> roleDivisions = null;
    private StateEnum state = null;
    private Date dateToDelete = null;
    private NamedEntity organization = null;

    public OrgOAuthClient() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.scope = new ArrayList<String>();
            this.roleDivisions = new ArrayList<RoleDivision>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OrgOAuthClient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the OAuth client.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrgOAuthClient dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this client was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public OrgOAuthClient dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this client was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public OrgOAuthClient createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created this client")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public OrgOAuthClient modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that last modified this client")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public OrgOAuthClient authorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. PKCE-Enabled Code Authorization grant type - Code grant type which requires PKCE challenge and verifier to create tokens. Used in public clients for increased security. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. ")
    @JsonProperty(value="authorizedGrantType")
    public AuthorizedGrantTypeEnum getAuthorizedGrantType() {
        return this.authorizedGrantType;
    }

    public void setAuthorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
    }

    public OrgOAuthClient scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", value="The scope requested by this client. Scopes only apply to clients not using the client_credential grant")
    @JsonProperty(value="scope")
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public OrgOAuthClient roleDivisions(List<RoleDivision> roleDivisions) {
        this.roleDivisions = roleDivisions;
        return this;
    }

    @ApiModelProperty(example="null", value="Set of roles and their corresponding divisions associated with this client. Roles and divisions only apply to clients using the client_credential grant")
    @JsonProperty(value="roleDivisions")
    public List<RoleDivision> getRoleDivisions() {
        return this.roleDivisions;
    }

    public void setRoleDivisions(List<RoleDivision> roleDivisions) {
        this.roleDivisions = roleDivisions;
    }

    public OrgOAuthClient state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the OAuth client. Active: The OAuth client can be used to create access tokens. This is the default state. Disabled: Access tokens created by the client are invalid and new ones cannot be created. Inactive: Access tokens cannot be created with this OAuth client and it will be deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OrgOAuthClient dateToDelete(Date dateToDelete) {
        this.dateToDelete = dateToDelete;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which this client will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateToDelete")
    public Date getDateToDelete() {
        return this.dateToDelete;
    }

    public void setDateToDelete(Date dateToDelete) {
        this.dateToDelete = dateToDelete;
    }

    @ApiModelProperty(example="null", value="The  oauth client's organization.")
    @JsonProperty(value="organization")
    public NamedEntity getOrganization() {
        return this.organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgOAuthClient orgOAuthClient = (OrgOAuthClient)o;
        return Objects.equals(this.id, orgOAuthClient.id) && Objects.equals(this.name, orgOAuthClient.name) && Objects.equals(this.dateCreated, orgOAuthClient.dateCreated) && Objects.equals(this.dateModified, orgOAuthClient.dateModified) && Objects.equals(this.createdBy, orgOAuthClient.createdBy) && Objects.equals(this.modifiedBy, orgOAuthClient.modifiedBy) && Objects.equals((Object)this.authorizedGrantType, (Object)orgOAuthClient.authorizedGrantType) && Objects.equals(this.scope, orgOAuthClient.scope) && Objects.equals(this.roleDivisions, orgOAuthClient.roleDivisions) && Objects.equals((Object)this.state, (Object)orgOAuthClient.state) && Objects.equals(this.dateToDelete, orgOAuthClient.dateToDelete) && Objects.equals(this.organization, orgOAuthClient.organization);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.authorizedGrantType, this.scope, this.roleDivisions, this.state, this.dateToDelete, this.organization});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOAuthClient {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    authorizedGrantType: ").append(this.toIndentedString((Object)this.authorizedGrantType)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    roleDivisions: ").append(this.toIndentedString(this.roleDivisions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateToDelete: ").append(this.toIndentedString(this.dateToDelete)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AuthorizedGrantTypeEnumDeserializer.class)
    public static enum AuthorizedGrantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODE("CODE"),
        TOKEN("TOKEN"),
        SAML2_BEARER("SAML2-BEARER"),
        PASSWORD("PASSWORD"),
        CLIENT_CREDENTIALS("CLIENT-CREDENTIALS");

        private String value;

        private AuthorizedGrantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthorizedGrantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AuthorizedGrantTypeEnum value : AuthorizedGrantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AuthorizedGrantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        DISABLED("disabled"),
        INACTIVE("inactive");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AuthorizedGrantTypeEnumDeserializer
    extends StdDeserializer<AuthorizedGrantTypeEnum> {
        public AuthorizedGrantTypeEnumDeserializer() {
            super(AuthorizedGrantTypeEnumDeserializer.class);
        }

        public AuthorizedGrantTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AuthorizedGrantTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

