/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class OperandPosition
implements Serializable {
    private Integer startingPositionValue = null;
    private StartingPositionDirectionEnum startingPositionDirection = null;
    private Integer endingPositionValue = null;
    private EndingPositionDirectionEnum endingPositionDirection = null;

    public OperandPosition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OperandPosition startingPositionValue(Integer startingPositionValue) {
        this.startingPositionValue = startingPositionValue;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines starting point of a position range - number of seconds or words from the start or from the end of the interaction")
    @JsonProperty(value="startingPositionValue")
    public Integer getStartingPositionValue() {
        return this.startingPositionValue;
    }

    public void setStartingPositionValue(Integer startingPositionValue) {
        this.startingPositionValue = startingPositionValue;
    }

    public OperandPosition startingPositionDirection(StartingPositionDirectionEnum startingPositionDirection) {
        this.startingPositionDirection = startingPositionDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="Dictates starting position directionality")
    @JsonProperty(value="startingPositionDirection")
    public StartingPositionDirectionEnum getStartingPositionDirection() {
        return this.startingPositionDirection;
    }

    public void setStartingPositionDirection(StartingPositionDirectionEnum startingPositionDirection) {
        this.startingPositionDirection = startingPositionDirection;
    }

    public OperandPosition endingPositionValue(Integer endingPositionValue) {
        this.endingPositionValue = endingPositionValue;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines ending point of a position range - number of seconds or words from the start or from the end of the interaction")
    @JsonProperty(value="endingPositionValue")
    public Integer getEndingPositionValue() {
        return this.endingPositionValue;
    }

    public void setEndingPositionValue(Integer endingPositionValue) {
        this.endingPositionValue = endingPositionValue;
    }

    public OperandPosition endingPositionDirection(EndingPositionDirectionEnum endingPositionDirection) {
        this.endingPositionDirection = endingPositionDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="Dictates ending position directionality")
    @JsonProperty(value="endingPositionDirection")
    public EndingPositionDirectionEnum getEndingPositionDirection() {
        return this.endingPositionDirection;
    }

    public void setEndingPositionDirection(EndingPositionDirectionEnum endingPositionDirection) {
        this.endingPositionDirection = endingPositionDirection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperandPosition operandPosition = (OperandPosition)o;
        return Objects.equals(this.startingPositionValue, operandPosition.startingPositionValue) && Objects.equals((Object)this.startingPositionDirection, (Object)operandPosition.startingPositionDirection) && Objects.equals(this.endingPositionValue, operandPosition.endingPositionValue) && Objects.equals((Object)this.endingPositionDirection, (Object)operandPosition.endingPositionDirection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startingPositionValue, this.startingPositionDirection, this.endingPositionValue, this.endingPositionDirection});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperandPosition {\n");
        sb.append("    startingPositionValue: ").append(this.toIndentedString(this.startingPositionValue)).append("\n");
        sb.append("    startingPositionDirection: ").append(this.toIndentedString((Object)this.startingPositionDirection)).append("\n");
        sb.append("    endingPositionValue: ").append(this.toIndentedString(this.endingPositionValue)).append("\n");
        sb.append("    endingPositionDirection: ").append(this.toIndentedString((Object)this.endingPositionDirection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StartingPositionDirectionEnumDeserializer.class)
    public static enum StartingPositionDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FROMSTART("FromStart"),
        FROMEND("FromEnd");

        private String value;

        private StartingPositionDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StartingPositionDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StartingPositionDirectionEnum value : StartingPositionDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StartingPositionDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=EndingPositionDirectionEnumDeserializer.class)
    public static enum EndingPositionDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FROMSTART("FromStart"),
        FROMEND("FromEnd");

        private String value;

        private EndingPositionDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EndingPositionDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EndingPositionDirectionEnum value : EndingPositionDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EndingPositionDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EndingPositionDirectionEnumDeserializer
    extends StdDeserializer<EndingPositionDirectionEnum> {
        public EndingPositionDirectionEnumDeserializer() {
            super(EndingPositionDirectionEnumDeserializer.class);
        }

        public EndingPositionDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EndingPositionDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StartingPositionDirectionEnumDeserializer
    extends StdDeserializer<StartingPositionDirectionEnum> {
        public StartingPositionDirectionEnumDeserializer() {
            super(StartingPositionDirectionEnumDeserializer.class);
        }

        public StartingPositionDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StartingPositionDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

