/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MessagingSettingRequestReference;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class OpenIntegrationRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private SupportedContentReference supportedContent = null;
    private MessagingSettingRequestReference messagingSetting = null;
    private String outboundNotificationWebhookUrl = null;
    private String outboundNotificationWebhookSignatureSecretToken = null;
    private Map<String, String> webhookHeaders = null;
    private String selfUri = null;

    public OpenIntegrationRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OpenIntegrationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Open messaging integration.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenIntegrationRequest supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the SupportedContent profile configured for an integration")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    public OpenIntegrationRequest messagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the message settings to be applied for this integration")
    @JsonProperty(value="messagingSetting")
    public MessagingSettingRequestReference getMessagingSetting() {
        return this.messagingSetting;
    }

    public void setMessagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
    }

    public OpenIntegrationRequest outboundNotificationWebhookUrl(String outboundNotificationWebhookUrl) {
        this.outboundNotificationWebhookUrl = outboundNotificationWebhookUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The outbound notification webhook URL for the Open messaging integration.")
    @JsonProperty(value="outboundNotificationWebhookUrl")
    public String getOutboundNotificationWebhookUrl() {
        return this.outboundNotificationWebhookUrl;
    }

    public void setOutboundNotificationWebhookUrl(String outboundNotificationWebhookUrl) {
        this.outboundNotificationWebhookUrl = outboundNotificationWebhookUrl;
    }

    public OpenIntegrationRequest outboundNotificationWebhookSignatureSecretToken(String outboundNotificationWebhookSignatureSecretToken) {
        this.outboundNotificationWebhookSignatureSecretToken = outboundNotificationWebhookSignatureSecretToken;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The outbound notification webhook signature secret token. This token must be longer than 15 characters.")
    @JsonProperty(value="outboundNotificationWebhookSignatureSecretToken")
    public String getOutboundNotificationWebhookSignatureSecretToken() {
        return this.outboundNotificationWebhookSignatureSecretToken;
    }

    public void setOutboundNotificationWebhookSignatureSecretToken(String outboundNotificationWebhookSignatureSecretToken) {
        this.outboundNotificationWebhookSignatureSecretToken = outboundNotificationWebhookSignatureSecretToken;
    }

    public OpenIntegrationRequest webhookHeaders(Map<String, String> webhookHeaders) {
        this.webhookHeaders = webhookHeaders;
        return this;
    }

    @ApiModelProperty(example="null", value="The user specified headers for the Open messaging integration.")
    @JsonProperty(value="webhookHeaders")
    public Map<String, String> getWebhookHeaders() {
        return this.webhookHeaders;
    }

    public void setWebhookHeaders(Map<String, String> webhookHeaders) {
        this.webhookHeaders = webhookHeaders;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIntegrationRequest openIntegrationRequest = (OpenIntegrationRequest)o;
        return Objects.equals(this.id, openIntegrationRequest.id) && Objects.equals(this.name, openIntegrationRequest.name) && Objects.equals(this.supportedContent, openIntegrationRequest.supportedContent) && Objects.equals(this.messagingSetting, openIntegrationRequest.messagingSetting) && Objects.equals(this.outboundNotificationWebhookUrl, openIntegrationRequest.outboundNotificationWebhookUrl) && Objects.equals(this.outboundNotificationWebhookSignatureSecretToken, openIntegrationRequest.outboundNotificationWebhookSignatureSecretToken) && Objects.equals(this.webhookHeaders, openIntegrationRequest.webhookHeaders) && Objects.equals(this.selfUri, openIntegrationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.supportedContent, this.messagingSetting, this.outboundNotificationWebhookUrl, this.outboundNotificationWebhookSignatureSecretToken, this.webhookHeaders, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIntegrationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    messagingSetting: ").append(this.toIndentedString(this.messagingSetting)).append("\n");
        sb.append("    outboundNotificationWebhookUrl: ").append(this.toIndentedString(this.outboundNotificationWebhookUrl)).append("\n");
        sb.append("    outboundNotificationWebhookSignatureSecretToken: ").append(this.toIndentedString(this.outboundNotificationWebhookSignatureSecretToken)).append("\n");
        sb.append("    webhookHeaders: ").append(this.toIndentedString(this.webhookHeaders)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

