/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class OpenDataIngestionRuleRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private DomainEntityRef externalSource = null;

    public OpenDataIngestionRuleRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OpenDataIngestionRuleRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the data ingestion rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenDataIngestionRuleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the data ingestion rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OpenDataIngestionRuleRequest externalSource(DomainEntityRef externalSource) {
        this.externalSource = externalSource;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external source associated with this open data ingestion rule, which will be used when performing identity resolution")
    @JsonProperty(value="externalSource")
    public DomainEntityRef getExternalSource() {
        return this.externalSource;
    }

    public void setExternalSource(DomainEntityRef externalSource) {
        this.externalSource = externalSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenDataIngestionRuleRequest openDataIngestionRuleRequest = (OpenDataIngestionRuleRequest)o;
        return Objects.equals(this.name, openDataIngestionRuleRequest.name) && Objects.equals(this.description, openDataIngestionRuleRequest.description) && Objects.equals(this.externalSource, openDataIngestionRuleRequest.externalSource);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.externalSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenDataIngestionRuleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalSource: ").append(this.toIndentedString(this.externalSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

