/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A Genesys Cloud resource created or modified as a result of running an accelerator")
public class MetadataResultEntity
implements Serializable {
    private String type = null;
    private String description = null;
    private VisibilityEnum visibility = null;

    public MetadataResultEntity() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="object type of the modified resource")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="description of the modified resource")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="whether the modified resource is visible or hidden")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataResultEntity metadataResultEntity = (MetadataResultEntity)o;
        return Objects.equals(this.type, metadataResultEntity.type) && Objects.equals(this.description, metadataResultEntity.description) && Objects.equals((Object)this.visibility, (Object)metadataResultEntity.visibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.description, this.visibility});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataResultEntity {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=VisibilityEnumDeserializer.class)
    public static enum VisibilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VISIBLE("Visible"),
        HIDDEN("Hidden");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VisibilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VisibilityEnum value : VisibilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VisibilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VisibilityEnumDeserializer
    extends StdDeserializer<VisibilityEnum> {
        public VisibilityEnumDeserializer() {
            super(VisibilityEnumDeserializer.class);
        }

        public VisibilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VisibilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

