/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ShiftTradeMatchViolation;
import com.mypurecloud.sdk.v2.model.ShiftTradeResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MatchShiftTradeResponse
implements Serializable {
    private ShiftTradeResponse trade = null;
    private List<ShiftTradeMatchViolation> violations = null;
    private List<ShiftTradeMatchViolation> adminReviewViolations = null;
    private List<UnevaluatedRulesEnum> unevaluatedRules = null;

    public MatchShiftTradeResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.violations = new ArrayList<ShiftTradeMatchViolation>();
            this.adminReviewViolations = new ArrayList<ShiftTradeMatchViolation>();
            this.unevaluatedRules = new ArrayList<UnevaluatedRulesEnum>();
        }
    }

    public MatchShiftTradeResponse trade(ShiftTradeResponse trade) {
        this.trade = trade;
        return this;
    }

    @ApiModelProperty(example="null", value="The associated shift trade")
    @JsonProperty(value="trade")
    public ShiftTradeResponse getTrade() {
        return this.trade;
    }

    public void setTrade(ShiftTradeResponse trade) {
        this.trade = trade;
    }

    public MatchShiftTradeResponse violations(List<ShiftTradeMatchViolation> violations) {
        this.violations = violations;
        return this;
    }

    @ApiModelProperty(example="null", value="Constraint violations which disallow this shift trade")
    @JsonProperty(value="violations")
    public List<ShiftTradeMatchViolation> getViolations() {
        return this.violations;
    }

    public void setViolations(List<ShiftTradeMatchViolation> violations) {
        this.violations = violations;
    }

    public MatchShiftTradeResponse adminReviewViolations(List<ShiftTradeMatchViolation> adminReviewViolations) {
        this.adminReviewViolations = adminReviewViolations;
        return this;
    }

    @ApiModelProperty(example="null", value="Constraint violations for this shift trade which require shift trade administrator review")
    @JsonProperty(value="adminReviewViolations")
    public List<ShiftTradeMatchViolation> getAdminReviewViolations() {
        return this.adminReviewViolations;
    }

    public void setAdminReviewViolations(List<ShiftTradeMatchViolation> adminReviewViolations) {
        this.adminReviewViolations = adminReviewViolations;
    }

    public MatchShiftTradeResponse unevaluatedRules(List<UnevaluatedRulesEnum> unevaluatedRules) {
        this.unevaluatedRules = unevaluatedRules;
        return this;
    }

    @ApiModelProperty(example="null", value="Unevaluated rules for this shift trade which require shift trade administrator review")
    @JsonProperty(value="unevaluatedRules")
    public List<UnevaluatedRulesEnum> getUnevaluatedRules() {
        return this.unevaluatedRules;
    }

    public void setUnevaluatedRules(List<UnevaluatedRulesEnum> unevaluatedRules) {
        this.unevaluatedRules = unevaluatedRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchShiftTradeResponse matchShiftTradeResponse = (MatchShiftTradeResponse)o;
        return Objects.equals(this.trade, matchShiftTradeResponse.trade) && Objects.equals(this.violations, matchShiftTradeResponse.violations) && Objects.equals(this.adminReviewViolations, matchShiftTradeResponse.adminReviewViolations) && Objects.equals(this.unevaluatedRules, matchShiftTradeResponse.unevaluatedRules);
    }

    public int hashCode() {
        return Objects.hash(this.trade, this.violations, this.adminReviewViolations, this.unevaluatedRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchShiftTradeResponse {\n");
        sb.append("    trade: ").append(this.toIndentedString(this.trade)).append("\n");
        sb.append("    violations: ").append(this.toIndentedString(this.violations)).append("\n");
        sb.append("    adminReviewViolations: ").append(this.toIndentedString(this.adminReviewViolations)).append("\n");
        sb.append("    unevaluatedRules: ").append(this.toIndentedString(this.unevaluatedRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnevaluatedRulesEnumDeserializer.class)
    public static enum UnevaluatedRulesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PLANNINGPERIODMINPAIDTIME("PlanningPeriodMinPaidTime"),
        PLANNINGPERIODMAXPAIDTIME("PlanningPeriodMaxPaidTime"),
        MINIMUMTIMEBETWEENSHIFTS("MinimumTimeBetweenShifts");

        private String value;

        private UnevaluatedRulesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnevaluatedRulesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnevaluatedRulesEnum value : UnevaluatedRulesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnevaluatedRulesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnevaluatedRulesEnumDeserializer
    extends StdDeserializer<UnevaluatedRulesEnum> {
        public UnevaluatedRulesEnumDeserializer() {
            super(UnevaluatedRulesEnumDeserializer.class);
        }

        public UnevaluatedRulesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnevaluatedRulesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

