/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Literal
implements Serializable {
    private String string = null;
    private Long integer = null;
    private Double number = null;
    private LocalDate date = null;
    private Date datetime = null;
    private SpecialEnum special = null;
    private List<String> strings = null;
    private Boolean _boolean = null;

    public Literal() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.strings = new ArrayList<String>();
        }
    }

    public Literal string(String string) {
        this.string = string;
        return this;
    }

    @ApiModelProperty(example="null", value="A string value")
    @JsonProperty(value="string")
    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public Literal integer(Long integer) {
        this.integer = integer;
        return this;
    }

    @ApiModelProperty(example="null", value="A positive or negative whole number, including zero")
    @JsonProperty(value="integer")
    public Long getInteger() {
        return this.integer;
    }

    public void setInteger(Long integer) {
        this.integer = integer;
    }

    public Literal number(Double number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(example="null", value="A positive or negative decimal number, including zero")
    @JsonProperty(value="number")
    public Double getNumber() {
        return this.number;
    }

    public void setNumber(Double number) {
        this.number = number;
    }

    public Literal date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="null", value="A date value, must be in the format of yyyy-MM-dd, e.g. 2024-09-23. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="date")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Literal datetime(Date datetime) {
        this.datetime = datetime;
        return this;
    }

    @ApiModelProperty(example="null", value="A date time value, must be in the format of yyyy-MM-dd'T'HH:mm:ss.SSSZ, e.g. 2024-10-02T01:01:01.111Z. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datetime")
    public Date getDatetime() {
        return this.datetime;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    public Literal special(SpecialEnum special) {
        this.special = special;
        return this;
    }

    @ApiModelProperty(example="null", value="A special value enum, such as Wildcard, Null, etc")
    @JsonProperty(value="special")
    public SpecialEnum getSpecial() {
        return this.special;
    }

    public void setSpecial(SpecialEnum special) {
        this.special = special;
    }

    public Literal strings(List<String> strings) {
        this.strings = strings;
        return this;
    }

    @ApiModelProperty(example="null", value="A string list value")
    @JsonProperty(value="strings")
    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(List<String> strings) {
        this.strings = strings;
    }

    public Literal _boolean(Boolean _boolean) {
        this._boolean = _boolean;
        return this;
    }

    @ApiModelProperty(example="null", value="A boolean value")
    @JsonProperty(value="boolean")
    public Boolean getBoolean() {
        return this._boolean;
    }

    public void setBoolean(Boolean _boolean) {
        this._boolean = _boolean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Literal literal = (Literal)o;
        return Objects.equals(this.string, literal.string) && Objects.equals(this.integer, literal.integer) && Objects.equals(this.number, literal.number) && Objects.equals(this.date, literal.date) && Objects.equals(this.datetime, literal.datetime) && Objects.equals((Object)this.special, (Object)literal.special) && Objects.equals(this.strings, literal.strings) && Objects.equals(this._boolean, literal._boolean);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.string, this.integer, this.number, this.date, this.datetime, this.special, this.strings, this._boolean});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Literal {\n");
        sb.append("    string: ").append(this.toIndentedString(this.string)).append("\n");
        sb.append("    integer: ").append(this.toIndentedString(this.integer)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    datetime: ").append(this.toIndentedString(this.datetime)).append("\n");
        sb.append("    special: ").append(this.toIndentedString((Object)this.special)).append("\n");
        sb.append("    strings: ").append(this.toIndentedString(this.strings)).append("\n");
        sb.append("    _boolean: ").append(this.toIndentedString(this._boolean)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SpecialEnumDeserializer.class)
    public static enum SpecialEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WILDCARD("Wildcard"),
        NULL("Null"),
        EMPTY("Empty"),
        CURRENTTIME("CurrentTime");

        private String value;

        private SpecialEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SpecialEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SpecialEnum value : SpecialEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SpecialEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SpecialEnumDeserializer
    extends StdDeserializer<SpecialEnum> {
        public SpecialEnumDeserializer() {
            super(SpecialEnumDeserializer.class);
        }

        public SpecialEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SpecialEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

