/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LearningScheduleSlotsJobRequest
implements Serializable {
    private List<String> userIds = null;
    private Integer lengthInMinutes = null;
    private String activityCodeId = null;
    private List<String> intervals = null;
    private SlotsTypeEnum slotsType = null;

    public LearningScheduleSlotsJobRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.userIds = new ArrayList<String>();
            this.intervals = new ArrayList<String>();
        }
    }

    public LearningScheduleSlotsJobRequest userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user IDs to fetch the slots for.")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public LearningScheduleSlotsJobRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length in minutes of the slots, in 15 minutes granularity.")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public LearningScheduleSlotsJobRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Activity Code Id of the slots.")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public LearningScheduleSlotsJobRequest intervals(List<String> intervals) {
        this.intervals = intervals;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The intervals to fetch the slots for. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="intervals")
    public List<String> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(List<String> intervals) {
        this.intervals = intervals;
    }

    public LearningScheduleSlotsJobRequest slotsType(SlotsTypeEnum slotsType) {
        this.slotsType = slotsType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of slots to fetch in the job.")
    @JsonProperty(value="slotsType")
    public SlotsTypeEnum getSlotsType() {
        return this.slotsType;
    }

    public void setSlotsType(SlotsTypeEnum slotsType) {
        this.slotsType = slotsType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningScheduleSlotsJobRequest learningScheduleSlotsJobRequest = (LearningScheduleSlotsJobRequest)o;
        return Objects.equals(this.userIds, learningScheduleSlotsJobRequest.userIds) && Objects.equals(this.lengthInMinutes, learningScheduleSlotsJobRequest.lengthInMinutes) && Objects.equals(this.activityCodeId, learningScheduleSlotsJobRequest.activityCodeId) && Objects.equals(this.intervals, learningScheduleSlotsJobRequest.intervals) && Objects.equals((Object)this.slotsType, (Object)learningScheduleSlotsJobRequest.slotsType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userIds, this.lengthInMinutes, this.activityCodeId, this.intervals, this.slotsType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningScheduleSlotsJobRequest {\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    intervals: ").append(this.toIndentedString(this.intervals)).append("\n");
        sb.append("    slotsType: ").append(this.toIndentedString((Object)this.slotsType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SlotsTypeEnumDeserializer.class)
    public static enum SlotsTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BESTTIME("BestTime");

        private String value;

        private SlotsTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SlotsTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SlotsTypeEnum value : SlotsTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SlotsTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SlotsTypeEnumDeserializer
    extends StdDeserializer<SlotsTypeEnum> {
        public SlotsTypeEnumDeserializer() {
            super(SlotsTypeEnumDeserializer.class);
        }

        public SlotsTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SlotsTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

