/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import com.mypurecloud.sdk.v2.model.KnowledgeExportJobFilter;
import com.mypurecloud.sdk.v2.model.KnowledgeOperationSource;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeExportJobResponse
implements Serializable {
    private String id = null;
    private String downloadURL = null;
    private FileTypeEnum fileType = null;
    private Integer jsonFileVersion = null;
    private Integer countDocumentProcessed = null;
    private KnowledgeExportJobFilter exportFilter = null;
    private StatusEnum status = null;
    private KnowledgeBase knowledgeBase = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private ErrorBody errorInformation = null;
    private KnowledgeOperationSource source = null;
    private String selfUri = null;

    public KnowledgeExportJobResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public KnowledgeExportJobResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the export job.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public KnowledgeExportJobResponse downloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the location at which the caller can download the export file, when available.")
    @JsonProperty(value="downloadURL")
    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public KnowledgeExportJobResponse fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="File type of the document")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public KnowledgeExportJobResponse jsonFileVersion(Integer jsonFileVersion) {
        this.jsonFileVersion = jsonFileVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Requested version of the exported json file.")
    @JsonProperty(value="jsonFileVersion")
    public Integer getJsonFileVersion() {
        return this.jsonFileVersion;
    }

    public void setJsonFileVersion(Integer jsonFileVersion) {
        this.jsonFileVersion = jsonFileVersion;
    }

    public KnowledgeExportJobResponse countDocumentProcessed(Integer countDocumentProcessed) {
        this.countDocumentProcessed = countDocumentProcessed;
        return this;
    }

    @ApiModelProperty(example="null", value="The current count of the number of records processed.")
    @JsonProperty(value="countDocumentProcessed")
    public Integer getCountDocumentProcessed() {
        return this.countDocumentProcessed;
    }

    public void setCountDocumentProcessed(Integer countDocumentProcessed) {
        this.countDocumentProcessed = countDocumentProcessed;
    }

    public KnowledgeExportJobResponse exportFilter(KnowledgeExportJobFilter exportFilter) {
        this.exportFilter = exportFilter;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters to narrow down what to export.")
    @JsonProperty(value="exportFilter")
    public KnowledgeExportJobFilter getExportFilter() {
        return this.exportFilter;
    }

    public void setExportFilter(KnowledgeExportJobFilter exportFilter) {
        this.exportFilter = exportFilter;
    }

    public KnowledgeExportJobResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the export job.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public KnowledgeExportJobResponse knowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge base which document export belongs to.")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public KnowledgeExportJobResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who created the operation")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public KnowledgeExportJobResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the export began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public KnowledgeExportJobResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the export stopped. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public KnowledgeExportJobResponse errorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error information, or null of the processing is not in failed state.")
    @JsonProperty(value="errorInformation")
    public ErrorBody getErrorInformation() {
        return this.errorInformation;
    }

    public void setErrorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
    }

    public KnowledgeExportJobResponse source(KnowledgeOperationSource source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", value="Source of the export job.")
    @JsonProperty(value="source")
    public KnowledgeOperationSource getSource() {
        return this.source;
    }

    public void setSource(KnowledgeOperationSource source) {
        this.source = source;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeExportJobResponse knowledgeExportJobResponse = (KnowledgeExportJobResponse)o;
        return Objects.equals(this.id, knowledgeExportJobResponse.id) && Objects.equals(this.downloadURL, knowledgeExportJobResponse.downloadURL) && Objects.equals((Object)this.fileType, (Object)knowledgeExportJobResponse.fileType) && Objects.equals(this.jsonFileVersion, knowledgeExportJobResponse.jsonFileVersion) && Objects.equals(this.countDocumentProcessed, knowledgeExportJobResponse.countDocumentProcessed) && Objects.equals(this.exportFilter, knowledgeExportJobResponse.exportFilter) && Objects.equals((Object)this.status, (Object)knowledgeExportJobResponse.status) && Objects.equals(this.knowledgeBase, knowledgeExportJobResponse.knowledgeBase) && Objects.equals(this.createdBy, knowledgeExportJobResponse.createdBy) && Objects.equals(this.dateCreated, knowledgeExportJobResponse.dateCreated) && Objects.equals(this.dateModified, knowledgeExportJobResponse.dateModified) && Objects.equals(this.errorInformation, knowledgeExportJobResponse.errorInformation) && Objects.equals(this.source, knowledgeExportJobResponse.source) && Objects.equals(this.selfUri, knowledgeExportJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.downloadURL, this.fileType, this.jsonFileVersion, this.countDocumentProcessed, this.exportFilter, this.status, this.knowledgeBase, this.createdBy, this.dateCreated, this.dateModified, this.errorInformation, this.source, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeExportJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    downloadURL: ").append(this.toIndentedString(this.downloadURL)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    jsonFileVersion: ").append(this.toIndentedString(this.jsonFileVersion)).append("\n");
        sb.append("    countDocumentProcessed: ").append(this.toIndentedString(this.countDocumentProcessed)).append("\n");
        sb.append("    exportFilter: ").append(this.toIndentedString(this.exportFilter)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    errorInformation: ").append(this.toIndentedString(this.errorInformation)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        JSON("Json"),
        CSV("Csv"),
        XLSX("Xlsx");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        VALIDATIONINPROGRESS("ValidationInProgress"),
        VALIDATIONCOMPLETED("ValidationCompleted"),
        VALIDATIONFAILED("ValidationFailed"),
        STARTED("Started"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        PARTIALCOMPLETED("PartialCompleted"),
        FAILED("Failed"),
        ABORTREQUESTED("AbortRequested"),
        ABORTED("Aborted");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

