/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DocumentBodyWithHighlight;
import com.mypurecloud.sdk.v2.model.DocumentVariationContext;
import com.mypurecloud.sdk.v2.model.DocumentVariationSearchChunkBlock;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentSearchVariation
implements Serializable {
    private String id = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef documentVersion = null;
    private List<DocumentVariationContext> contexts = null;
    private KnowledgeDocumentReference document = null;
    private Integer priority = null;
    private String name = null;
    private DocumentBodyWithHighlight body = null;
    private List<DocumentVariationSearchChunkBlock> chunks = null;
    private String selfUri = null;

    public KnowledgeDocumentSearchVariation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.contexts = new ArrayList<DocumentVariationContext>();
            this.chunks = new ArrayList<DocumentVariationSearchChunkBlock>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the variation.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The creation date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The last modification date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public KnowledgeDocumentSearchVariation documentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the document.")
    @JsonProperty(value="documentVersion")
    public AddressableEntityRef getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
    }

    public KnowledgeDocumentSearchVariation contexts(List<DocumentVariationContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The context values associated with the variation.")
    @JsonProperty(value="contexts")
    public List<DocumentVariationContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<DocumentVariationContext> contexts) {
        this.contexts = contexts;
    }

    @ApiModelProperty(example="null", value="The reference to document to which the variation is associated.")
    @JsonProperty(value="document")
    public KnowledgeDocumentReference getDocument() {
        return this.document;
    }

    public KnowledgeDocumentSearchVariation priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the variation.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public KnowledgeDocumentSearchVariation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the variation.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeDocumentSearchVariation body(DocumentBodyWithHighlight body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="The content for the variation.")
    @JsonProperty(value="body")
    public DocumentBodyWithHighlight getBody() {
        return this.body;
    }

    public void setBody(DocumentBodyWithHighlight body) {
        this.body = body;
    }

    public KnowledgeDocumentSearchVariation chunks(List<DocumentVariationSearchChunkBlock> chunks) {
        this.chunks = chunks;
        return this;
    }

    @ApiModelProperty(example="null", value="The chunk blocks associated with the variation.")
    @JsonProperty(value="chunks")
    public List<DocumentVariationSearchChunkBlock> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<DocumentVariationSearchChunkBlock> chunks) {
        this.chunks = chunks;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentSearchVariation knowledgeDocumentSearchVariation = (KnowledgeDocumentSearchVariation)o;
        return Objects.equals(this.id, knowledgeDocumentSearchVariation.id) && Objects.equals(this.dateCreated, knowledgeDocumentSearchVariation.dateCreated) && Objects.equals(this.dateModified, knowledgeDocumentSearchVariation.dateModified) && Objects.equals(this.documentVersion, knowledgeDocumentSearchVariation.documentVersion) && Objects.equals(this.contexts, knowledgeDocumentSearchVariation.contexts) && Objects.equals(this.document, knowledgeDocumentSearchVariation.document) && Objects.equals(this.priority, knowledgeDocumentSearchVariation.priority) && Objects.equals(this.name, knowledgeDocumentSearchVariation.name) && Objects.equals(this.body, knowledgeDocumentSearchVariation.body) && Objects.equals(this.chunks, knowledgeDocumentSearchVariation.chunks) && Objects.equals(this.selfUri, knowledgeDocumentSearchVariation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dateCreated, this.dateModified, this.documentVersion, this.contexts, this.document, this.priority, this.name, this.body, this.chunks, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentSearchVariation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    documentVersion: ").append(this.toIndentedString(this.documentVersion)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    chunks: ").append(this.toIndentedString(this.chunks)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

