/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.JourneyViewLinkTimeConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A link between elements in a journey view")
public class JourneyViewLink
implements Serializable {
    private String id = null;
    private JourneyViewLinkTimeConstraint constraintWithin = null;
    private JourneyViewLinkTimeConstraint constraintAfter = null;
    private EventCountTypeEnum eventCountType = null;
    private List<String> joinAttributes = null;

    public JourneyViewLink() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.joinAttributes = new ArrayList<String>();
        }
    }

    public JourneyViewLink id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The identifier of the element downstream")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JourneyViewLink constraintWithin(JourneyViewLinkTimeConstraint constraintWithin) {
        this.constraintWithin = constraintWithin;
        return this;
    }

    @ApiModelProperty(example="null", value="A time constraint on this link, which requires a customer to complete the downstream element within this amount of time to be counted.")
    @JsonProperty(value="constraintWithin")
    public JourneyViewLinkTimeConstraint getConstraintWithin() {
        return this.constraintWithin;
    }

    public void setConstraintWithin(JourneyViewLinkTimeConstraint constraintWithin) {
        this.constraintWithin = constraintWithin;
    }

    public JourneyViewLink constraintAfter(JourneyViewLinkTimeConstraint constraintAfter) {
        this.constraintAfter = constraintAfter;
        return this;
    }

    @ApiModelProperty(example="null", value="A time constraint on this link, which requires a customer must complete the downstream element after this amount of time to be counted.")
    @JsonProperty(value="constraintAfter")
    public JourneyViewLinkTimeConstraint getConstraintAfter() {
        return this.constraintAfter;
    }

    public void setConstraintAfter(JourneyViewLinkTimeConstraint constraintAfter) {
        this.constraintAfter = constraintAfter;
    }

    public JourneyViewLink eventCountType(EventCountTypeEnum eventCountType) {
        this.eventCountType = eventCountType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of events that will be counted. Note: Concurrent will override any JourneyViewLinkTimeConstraint. Default is Sequential.")
    @JsonProperty(value="eventCountType")
    public EventCountTypeEnum getEventCountType() {
        return this.eventCountType;
    }

    public void setEventCountType(EventCountTypeEnum eventCountType) {
        this.eventCountType = eventCountType;
    }

    public JourneyViewLink joinAttributes(List<String> joinAttributes) {
        this.joinAttributes = joinAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Other (secondary) attributes on which this link should join the customers being counted")
    @JsonProperty(value="joinAttributes")
    public List<String> getJoinAttributes() {
        return this.joinAttributes;
    }

    public void setJoinAttributes(List<String> joinAttributes) {
        this.joinAttributes = joinAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewLink journeyViewLink = (JourneyViewLink)o;
        return Objects.equals(this.id, journeyViewLink.id) && Objects.equals(this.constraintWithin, journeyViewLink.constraintWithin) && Objects.equals(this.constraintAfter, journeyViewLink.constraintAfter) && Objects.equals((Object)this.eventCountType, (Object)journeyViewLink.eventCountType) && Objects.equals(this.joinAttributes, journeyViewLink.joinAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.constraintWithin, this.constraintAfter, this.eventCountType, this.joinAttributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewLink {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    constraintWithin: ").append(this.toIndentedString(this.constraintWithin)).append("\n");
        sb.append("    constraintAfter: ").append(this.toIndentedString(this.constraintAfter)).append("\n");
        sb.append("    eventCountType: ").append(this.toIndentedString((Object)this.eventCountType)).append("\n");
        sb.append("    joinAttributes: ").append(this.toIndentedString(this.joinAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EventCountTypeEnumDeserializer.class)
    public static enum EventCountTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALL("All"),
        CONCURRENT("Concurrent"),
        SEQUENTIAL("Sequential");

        private String value;

        private EventCountTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EventCountTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EventCountTypeEnum value : EventCountTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EventCountTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EventCountTypeEnumDeserializer
    extends StdDeserializer<EventCountTypeEnum> {
        public EventCountTypeEnumDeserializer() {
            super(EventCountTypeEnumDeserializer.class);
        }

        public EventCountTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EventCountTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

