/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class InvoiceAddress
implements Serializable {
    private LocalDate dateEffective = null;
    private AddressTypeEnum addressType = null;
    private String currencyIsoCode = null;
    private String line1 = null;
    private String line2 = null;
    private String line3 = null;
    private String cityName = null;
    private String postalCode = null;
    private String stateCode = null;
    private String countryCode = null;
    private String citySubdivision1 = null;
    private String regionSubdivision1 = null;
    private String regionSubdivision2 = null;
    private String country = null;

    public InvoiceAddress() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public InvoiceAddress dateEffective(LocalDate dateEffective) {
        this.dateEffective = dateEffective;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEffective")
    public LocalDate getDateEffective() {
        return this.dateEffective;
    }

    public void setDateEffective(LocalDate dateEffective) {
        this.dateEffective = dateEffective;
    }

    public InvoiceAddress addressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of address.")
    @JsonProperty(value="addressType")
    public AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
    }

    public InvoiceAddress currencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains the ISO code for any currency allowed by the organization.")
    @JsonProperty(value="currencyIsoCode")
    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public void setCurrencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public InvoiceAddress line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @ApiModelProperty(example="null", value="The first line of the Address.")
    @JsonProperty(value="line1")
    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public InvoiceAddress line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @ApiModelProperty(example="null", value="The second line of the Address.")
    @JsonProperty(value="line2")
    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public InvoiceAddress line3(String line3) {
        this.line3 = line3;
        return this;
    }

    @ApiModelProperty(example="null", value="The third line of the Address.")
    @JsonProperty(value="line3")
    public String getLine3() {
        return this.line3;
    }

    public void setLine3(String line3) {
        this.line3 = line3;
    }

    public InvoiceAddress cityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    @ApiModelProperty(example="null", value="The city name.")
    @JsonProperty(value="cityName")
    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public InvoiceAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The Postal or Zip Code.")
    @JsonProperty(value="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public InvoiceAddress stateCode(String stateCode) {
        this.stateCode = stateCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The code that reflects the geographic state for the Address.")
    @JsonProperty(value="stateCode")
    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public InvoiceAddress countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The code representing the country for the Address (ISO_3166).")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public InvoiceAddress citySubdivision1(String citySubdivision1) {
        this.citySubdivision1 = citySubdivision1;
        return this;
    }

    @ApiModelProperty(example="null", value="The primary subdivision within a city (e.g., district, neighborhood).")
    @JsonProperty(value="citySubdivision1")
    public String getCitySubdivision1() {
        return this.citySubdivision1;
    }

    public void setCitySubdivision1(String citySubdivision1) {
        this.citySubdivision1 = citySubdivision1;
    }

    public InvoiceAddress regionSubdivision1(String regionSubdivision1) {
        this.regionSubdivision1 = regionSubdivision1;
        return this;
    }

    @ApiModelProperty(example="null", value="The primary administrative division within a region (e.g., state, province).")
    @JsonProperty(value="regionSubdivision1")
    public String getRegionSubdivision1() {
        return this.regionSubdivision1;
    }

    public void setRegionSubdivision1(String regionSubdivision1) {
        this.regionSubdivision1 = regionSubdivision1;
    }

    public InvoiceAddress regionSubdivision2(String regionSubdivision2) {
        this.regionSubdivision2 = regionSubdivision2;
        return this;
    }

    @ApiModelProperty(example="null", value="A secondary subdivision within the primary region subdivision (e.g., county, district).")
    @JsonProperty(value="regionSubdivision2")
    public String getRegionSubdivision2() {
        return this.regionSubdivision2;
    }

    public void setRegionSubdivision2(String regionSubdivision2) {
        this.regionSubdivision2 = regionSubdivision2;
    }

    public InvoiceAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="null", value="Stores the name of the country in which the address is situated.")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceAddress invoiceAddress = (InvoiceAddress)o;
        return Objects.equals(this.dateEffective, invoiceAddress.dateEffective) && Objects.equals((Object)this.addressType, (Object)invoiceAddress.addressType) && Objects.equals(this.currencyIsoCode, invoiceAddress.currencyIsoCode) && Objects.equals(this.line1, invoiceAddress.line1) && Objects.equals(this.line2, invoiceAddress.line2) && Objects.equals(this.line3, invoiceAddress.line3) && Objects.equals(this.cityName, invoiceAddress.cityName) && Objects.equals(this.postalCode, invoiceAddress.postalCode) && Objects.equals(this.stateCode, invoiceAddress.stateCode) && Objects.equals(this.countryCode, invoiceAddress.countryCode) && Objects.equals(this.citySubdivision1, invoiceAddress.citySubdivision1) && Objects.equals(this.regionSubdivision1, invoiceAddress.regionSubdivision1) && Objects.equals(this.regionSubdivision2, invoiceAddress.regionSubdivision2) && Objects.equals(this.country, invoiceAddress.country);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateEffective, this.addressType, this.currencyIsoCode, this.line1, this.line2, this.line3, this.cityName, this.postalCode, this.stateCode, this.countryCode, this.citySubdivision1, this.regionSubdivision1, this.regionSubdivision2, this.country});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceAddress {\n");
        sb.append("    dateEffective: ").append(this.toIndentedString(this.dateEffective)).append("\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    currencyIsoCode: ").append(this.toIndentedString(this.currencyIsoCode)).append("\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    line3: ").append(this.toIndentedString(this.line3)).append("\n");
        sb.append("    cityName: ").append(this.toIndentedString(this.cityName)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateCode: ").append(this.toIndentedString(this.stateCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    citySubdivision1: ").append(this.toIndentedString(this.citySubdivision1)).append("\n");
        sb.append("    regionSubdivision1: ").append(this.toIndentedString(this.regionSubdivision1)).append("\n");
        sb.append("    regionSubdivision2: ").append(this.toIndentedString(this.regionSubdivision2)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AddressTypeEnumDeserializer.class)
    public static enum AddressTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BILLTO("BillTo"),
        SHIPTO("ShipTo"),
        ENDUSER("EndUser"),
        SOLDTO("SoldTo");

        private String value;

        private AddressTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AddressTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AddressTypeEnum value : AddressTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AddressTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AddressTypeEnumDeserializer
    extends StdDeserializer<AddressTypeEnum> {
        public AddressTypeEnumDeserializer() {
            super(AddressTypeEnumDeserializer.class);
        }

        public AddressTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AddressTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

