/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ConversationNormalizedMessage;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class InternalMessageData
implements Serializable {
    private String id = null;
    private String name = null;
    private AddressableEntityRef conversation = null;
    private String communicationId = null;
    private Date timestamp = null;
    private UserReference sender = null;
    private UserReference recipient = null;
    private ConversationNormalizedMessage normalizedMessage = null;
    private String selfUri = null;

    public InternalMessageData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public InternalMessageData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InternalMessageData conversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="The conversation of this message.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public void setConversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
    }

    public InternalMessageData communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the communication of this message.")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public InternalMessageData timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public InternalMessageData sender(UserReference sender) {
        this.sender = sender;
        return this;
    }

    @ApiModelProperty(example="null", value="The sender of the text message.")
    @JsonProperty(value="sender")
    public UserReference getSender() {
        return this.sender;
    }

    public void setSender(UserReference sender) {
        this.sender = sender;
    }

    public InternalMessageData recipient(UserReference recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient of the text message.")
    @JsonProperty(value="recipient")
    public UserReference getRecipient() {
        return this.recipient;
    }

    public void setRecipient(UserReference recipient) {
        this.recipient = recipient;
    }

    @ApiModelProperty(example="null", value="The message into normalized format")
    @JsonProperty(value="normalizedMessage")
    public ConversationNormalizedMessage getNormalizedMessage() {
        return this.normalizedMessage;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMessageData internalMessageData = (InternalMessageData)o;
        return Objects.equals(this.id, internalMessageData.id) && Objects.equals(this.name, internalMessageData.name) && Objects.equals(this.conversation, internalMessageData.conversation) && Objects.equals(this.communicationId, internalMessageData.communicationId) && Objects.equals(this.timestamp, internalMessageData.timestamp) && Objects.equals(this.sender, internalMessageData.sender) && Objects.equals(this.recipient, internalMessageData.recipient) && Objects.equals(this.normalizedMessage, internalMessageData.normalizedMessage) && Objects.equals(this.selfUri, internalMessageData.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.conversation, this.communicationId, this.timestamp, this.sender, this.recipient, this.normalizedMessage, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InternalMessageData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    normalizedMessage: ").append(this.toIndentedString(this.normalizedMessage)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

