/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Input component configuration")
public class Input
implements Serializable {
    private String id = null;
    private String title = null;
    private String subtitle = null;
    private String placeholderText = null;
    private Boolean isMultipleLine = null;
    private Boolean isRequired = null;

    public Input() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Input id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the input field")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Input title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Title of the input field")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Input subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Subtitle of the input field")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Input placeholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        return this;
    }

    @ApiModelProperty(example="null", value="Placeholder text for the input")
    @JsonProperty(value="placeholderText")
    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
    }

    public Input isMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input supports multiple lines")
    @JsonProperty(value="isMultipleLine")
    public Boolean getIsMultipleLine() {
        return this.isMultipleLine;
    }

    public void setIsMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
    }

    public Input isRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input is required")
    @JsonProperty(value="isRequired")
    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.id, input.id) && Objects.equals(this.title, input.title) && Objects.equals(this.subtitle, input.subtitle) && Objects.equals(this.placeholderText, input.placeholderText) && Objects.equals(this.isMultipleLine, input.isMultipleLine) && Objects.equals(this.isRequired, input.isRequired);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.subtitle, this.placeholderText, this.isMultipleLine, this.isRequired);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Input {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    placeholderText: ").append(this.toIndentedString(this.placeholderText)).append("\n");
        sb.append("    isMultipleLine: ").append(this.toIndentedString(this.isMultipleLine)).append("\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

