/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class InactivityTimeoutSettings
implements Serializable {
    private Integer timeoutSeconds = null;
    private ActionTypeEnum actionType = null;
    private DomainEntityRef flowId = null;

    public InactivityTimeoutSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public InactivityTimeoutSettings timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Timeout in seconds for inactivity on the interaction")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public InactivityTimeoutSettings actionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(example="null", value="Action to take when timeout occurs")
    @JsonProperty(value="actionType")
    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
    }

    public InactivityTimeoutSettings flowId(DomainEntityRef flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="Flow ID for architect flow action")
    @JsonProperty(value="flowId")
    public DomainEntityRef getFlowId() {
        return this.flowId;
    }

    public void setFlowId(DomainEntityRef flowId) {
        this.flowId = flowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InactivityTimeoutSettings inactivityTimeoutSettings = (InactivityTimeoutSettings)o;
        return Objects.equals(this.timeoutSeconds, inactivityTimeoutSettings.timeoutSeconds) && Objects.equals((Object)this.actionType, (Object)inactivityTimeoutSettings.actionType) && Objects.equals(this.flowId, inactivityTimeoutSettings.flowId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeoutSeconds, this.actionType, this.flowId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InactivityTimeoutSettings {\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("    actionType: ").append(this.toIndentedString((Object)this.actionType)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionTypeEnumDeserializer.class)
    public static enum ActionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DISCONNECT("DISCONNECT"),
        SEND_TO_ARCHITECT_FLOW("SEND_TO_ARCHITECT_FLOW");

        private String value;

        private ActionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionTypeEnum value : ActionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionTypeEnumDeserializer
    extends StdDeserializer<ActionTypeEnum> {
        public ActionTypeEnumDeserializer() {
            super(ActionTypeEnumDeserializer.class);
        }

        public ActionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

