/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.GuideSessionTurnInvocationResponse;
import com.mypurecloud.sdk.v2.model.GuideSessionTurnResponseData;
import com.mypurecloud.sdk.v2.model.GuideSessionVariable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Response for a guide session turn")
public class GuideSessionTurnResponse
implements Serializable {
    private GuideSessionTurnResponseData response = null;
    private StatusEnum status = null;
    private ResultEnum result = null;
    private List<GuideSessionVariable> outputVariables = null;
    private String invocationId = null;
    private List<GuideSessionTurnInvocationResponse> invocations = null;

    public GuideSessionTurnResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.outputVariables = new ArrayList<GuideSessionVariable>();
            this.invocations = new ArrayList<GuideSessionTurnInvocationResponse>();
        }
    }

    public GuideSessionTurnResponse response(GuideSessionTurnResponseData response) {
        this.response = response;
        return this;
    }

    @ApiModelProperty(example="null", value="The response content for this turn.")
    @JsonProperty(value="response")
    public GuideSessionTurnResponseData getResponse() {
        return this.response;
    }

    public void setResponse(GuideSessionTurnResponseData response) {
        this.response = response;
    }

    public GuideSessionTurnResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the turn.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public GuideSessionTurnResponse result(ResultEnum result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(example="null", value="The result of the turn.")
    @JsonProperty(value="result")
    public ResultEnum getResult() {
        return this.result;
    }

    public void setResult(ResultEnum result) {
        this.result = result;
    }

    public GuideSessionTurnResponse outputVariables(List<GuideSessionVariable> outputVariables) {
        this.outputVariables = outputVariables;
        return this;
    }

    @ApiModelProperty(example="null", value="The output variables for this turn.")
    @JsonProperty(value="outputVariables")
    public List<GuideSessionVariable> getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(List<GuideSessionVariable> outputVariables) {
        this.outputVariables = outputVariables;
    }

    public GuideSessionTurnResponse invocationId(String invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Invocation ID for this turn.")
    @JsonProperty(value="invocationId")
    public String getInvocationId() {
        return this.invocationId;
    }

    public void setInvocationId(String invocationId) {
        this.invocationId = invocationId;
    }

    public GuideSessionTurnResponse invocations(List<GuideSessionTurnInvocationResponse> invocations) {
        this.invocations = invocations;
        return this;
    }

    @ApiModelProperty(example="null", value="The invocations for this turn.")
    @JsonProperty(value="invocations")
    public List<GuideSessionTurnInvocationResponse> getInvocations() {
        return this.invocations;
    }

    public void setInvocations(List<GuideSessionTurnInvocationResponse> invocations) {
        this.invocations = invocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuideSessionTurnResponse guideSessionTurnResponse = (GuideSessionTurnResponse)o;
        return Objects.equals(this.response, guideSessionTurnResponse.response) && Objects.equals((Object)this.status, (Object)guideSessionTurnResponse.status) && Objects.equals((Object)this.result, (Object)guideSessionTurnResponse.result) && Objects.equals(this.outputVariables, guideSessionTurnResponse.outputVariables) && Objects.equals(this.invocationId, guideSessionTurnResponse.invocationId) && Objects.equals(this.invocations, guideSessionTurnResponse.invocations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.response, this.status, this.result, this.outputVariables, this.invocationId, this.invocations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuideSessionTurnResponse {\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    outputVariables: ").append(this.toIndentedString(this.outputVariables)).append("\n");
        sb.append("    invocationId: ").append(this.toIndentedString(this.invocationId)).append("\n");
        sb.append("    invocations: ").append(this.toIndentedString(this.invocations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IN_PROGRESS("IN_PROGRESS"),
        COMPLETED("COMPLETED"),
        ERROR("ERROR");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ResultEnumDeserializer.class)
    public static enum ResultEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESSFUL_COLLECTION("SUCCESSFUL_COLLECTION"),
        CONFIRMATION_REQUIRED("CONFIRMATION_REQUIRED"),
        ESCALATION_TRIGGERED("ESCALATION_TRIGGERED"),
        CLIENT_ACTION_REQUIRED("CLIENT_ACTION_REQUIRED"),
        NO_MATCH("NO_MATCH");

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ResultEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ResultEnum value : ResultEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ResultEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ResultEnumDeserializer
    extends StdDeserializer<ResultEnum> {
        public ResultEnumDeserializer() {
            super(ResultEnumDeserializer.class);
        }

        public ResultEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ResultEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

