/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Parameters for launching a flow.")
public class FlowExecutionLaunchRequest
implements Serializable {
    private String flowId = null;
    private String flowVersion = null;
    private Map<String, Object> inputData = null;
    private String name = null;

    public FlowExecutionLaunchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public FlowExecutionLaunchRequest flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the flow to launch.")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public FlowExecutionLaunchRequest flowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the flow to launch. Omit this value (or supply null/empty) to use the latest published version.")
    @JsonProperty(value="flowVersion")
    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public FlowExecutionLaunchRequest inputData(Map<String, Object> inputData) {
        this.inputData = inputData;
        return this;
    }

    @ApiModelProperty(example="null", value="Input values to the flow. Valid values are defined by a flow's input JSON schema.")
    @JsonProperty(value="inputData")
    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<String, Object> inputData) {
        this.inputData = inputData;
    }

    public FlowExecutionLaunchRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="A displayable name to assign to the new flow execution")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowExecutionLaunchRequest flowExecutionLaunchRequest = (FlowExecutionLaunchRequest)o;
        return Objects.equals(this.flowId, flowExecutionLaunchRequest.flowId) && Objects.equals(this.flowVersion, flowExecutionLaunchRequest.flowVersion) && Objects.equals(this.inputData, flowExecutionLaunchRequest.inputData) && Objects.equals(this.name, flowExecutionLaunchRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.flowId, this.flowVersion, this.inputData, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowExecutionLaunchRequest {\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString(this.flowVersion)).append("\n");
        sb.append("    inputData: ").append(this.toIndentedString(this.inputData)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

