/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EnrichFieldRules;
import com.mypurecloud.sdk.v2.model.ExternalOrganization;
import com.mypurecloud.sdk.v2.model.ExternalOrganizationIdentifier;
import com.mypurecloud.sdk.v2.model.WritableStarrableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExternalOrganizationEnrichRequest
implements Serializable {
    private String id = null;
    private WritableStarrableDivision division = null;
    private List<ExternalOrganizationIdentifier> matchingIdentifiers = null;
    private ActionEnum action = null;
    private ExternalOrganization externalOrganization = null;
    private EnrichFieldRules fieldRules = null;
    private String selfUri = null;

    public ExternalOrganizationEnrichRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.matchingIdentifiers = new ArrayList<ExternalOrganizationIdentifier>();
        }
    }

    public ExternalOrganizationEnrichRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating request and response operations.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalOrganizationEnrichRequest division(WritableStarrableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableStarrableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableStarrableDivision division) {
        this.division = division;
    }

    public ExternalOrganizationEnrichRequest matchingIdentifiers(List<ExternalOrganizationIdentifier> matchingIdentifiers) {
        this.matchingIdentifiers = matchingIdentifiers;
        return this;
    }

    @ApiModelProperty(example="null", value="An ordered list of one or more Identifiers which might each be claimed by an External Organization. `action` describes what to do with any possibly matching External Organization. Identifier lookups will occur in the order specified here.")
    @JsonProperty(value="matchingIdentifiers")
    public List<ExternalOrganizationIdentifier> getMatchingIdentifiers() {
        return this.matchingIdentifiers;
    }

    public void setMatchingIdentifiers(List<ExternalOrganizationIdentifier> matchingIdentifiers) {
        this.matchingIdentifiers = matchingIdentifiers;
    }

    public ExternalOrganizationEnrichRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The action that should be taken based on any External Organization found by `matchingIdentifiers`.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ExternalOrganizationEnrichRequest externalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Data to be added, either as an update to an existing External Organization or the body of a new External Organization. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.")
    @JsonProperty(value="externalOrganization")
    public ExternalOrganization getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public ExternalOrganizationEnrichRequest fieldRules(EnrichFieldRules fieldRules) {
        this.fieldRules = fieldRules;
        return this;
    }

    @ApiModelProperty(example="null", value="Logic describing how to combine data from the submitted request with data found in the database.")
    @JsonProperty(value="fieldRules")
    public EnrichFieldRules getFieldRules() {
        return this.fieldRules;
    }

    public void setFieldRules(EnrichFieldRules fieldRules) {
        this.fieldRules = fieldRules;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalOrganizationEnrichRequest externalOrganizationEnrichRequest = (ExternalOrganizationEnrichRequest)o;
        return Objects.equals(this.id, externalOrganizationEnrichRequest.id) && Objects.equals(this.division, externalOrganizationEnrichRequest.division) && Objects.equals(this.matchingIdentifiers, externalOrganizationEnrichRequest.matchingIdentifiers) && Objects.equals((Object)this.action, (Object)externalOrganizationEnrichRequest.action) && Objects.equals(this.externalOrganization, externalOrganizationEnrichRequest.externalOrganization) && Objects.equals(this.fieldRules, externalOrganizationEnrichRequest.fieldRules) && Objects.equals(this.selfUri, externalOrganizationEnrichRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.division, this.matchingIdentifiers, this.action, this.externalOrganization, this.fieldRules, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalOrganizationEnrichRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    matchingIdentifiers: ").append(this.toIndentedString(this.matchingIdentifiers)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    fieldRules: ").append(this.toIndentedString(this.fieldRules)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UPSERT("Upsert"),
        UPDATE("Update"),
        INSERT("Insert");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

