/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class ExternalMetricDataItem
implements Serializable {
    private String userId = null;
    private String userEmail = null;
    private String metricId = null;
    private LocalDate dateOccurred = null;
    private BigDecimal value = null;
    private Integer count = null;
    private TypeEnum type = null;

    public ExternalMetricDataItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ExternalMetricDataItem userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID. Must provide either userId or userEmail, but not both.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ExternalMetricDataItem userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(example="null", value="The user main email used in user's GenesysCloud account. Must provide either userId or userEmail, but not both.")
    @JsonProperty(value="userEmail")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public ExternalMetricDataItem metricId(String metricId) {
        this.metricId = metricId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the external metric definition")
    @JsonProperty(value="metricId")
    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public ExternalMetricDataItem dateOccurred(LocalDate dateOccurred) {
        this.dateOccurred = dateOccurred;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date of the metric data. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateOccurred")
    public LocalDate getDateOccurred() {
        return this.dateOccurred;
    }

    public void setDateOccurred(LocalDate dateOccurred) {
        this.dateOccurred = dateOccurred;
    }

    public ExternalMetricDataItem value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value of the metric data. When value is null, the metric data will be deleted.")
    @JsonProperty(value="value")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public ExternalMetricDataItem count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of data points. The default value is 0 when type is Cumulative and the metric data already exists, otherwise 1. When total count reaches 0, the metric data will be deleted.")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public ExternalMetricDataItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the metric data. The default value is Total.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricDataItem externalMetricDataItem = (ExternalMetricDataItem)o;
        return Objects.equals(this.userId, externalMetricDataItem.userId) && Objects.equals(this.userEmail, externalMetricDataItem.userEmail) && Objects.equals(this.metricId, externalMetricDataItem.metricId) && Objects.equals(this.dateOccurred, externalMetricDataItem.dateOccurred) && Objects.equals(this.value, externalMetricDataItem.value) && Objects.equals(this.count, externalMetricDataItem.count) && Objects.equals((Object)this.type, (Object)externalMetricDataItem.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.userEmail, this.metricId, this.dateOccurred, this.value, this.count, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalMetricDataItem {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    metricId: ").append(this.toIndentedString(this.metricId)).append("\n");
        sb.append("    dateOccurred: ").append(this.toIndentedString(this.dateOccurred)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TOTAL("Total"),
        CUMULATIVE("Cumulative");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

