/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DynamicGroupSkillCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DynamicGroupLanguageSkillCondition
implements Serializable {
    private String languageSkill = null;
    private ComparatorEnum comparator = null;
    private Integer proficiency = null;
    private List<DynamicGroupSkillCondition> childConditions = null;

    public DynamicGroupLanguageSkillCondition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.childConditions = new ArrayList<DynamicGroupSkillCondition>();
        }
    }

    public DynamicGroupLanguageSkillCondition languageSkill(String languageSkill) {
        this.languageSkill = languageSkill;
        return this;
    }

    @ApiModelProperty(example="English-Written", required=true, value="The language skill to be used in the skill condition query")
    @JsonProperty(value="languageSkill")
    public String getLanguageSkill() {
        return this.languageSkill;
    }

    public void setLanguageSkill(String languageSkill) {
        this.languageSkill = languageSkill;
    }

    public DynamicGroupLanguageSkillCondition comparator(ComparatorEnum comparator) {
        this.comparator = comparator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Comparator that will be applied to the proficiency")
    @JsonProperty(value="comparator")
    public ComparatorEnum getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorEnum comparator) {
        this.comparator = comparator;
    }

    public DynamicGroupLanguageSkillCondition proficiency(Integer proficiency) {
        this.proficiency = proficiency;
        return this;
    }

    @ApiModelProperty(example="5", required=true, value="The skill proficiency that will be used for the language skill. Integer range 0-5")
    @JsonProperty(value="proficiency")
    public Integer getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(Integer proficiency) {
        this.proficiency = proficiency;
    }

    public DynamicGroupLanguageSkillCondition childConditions(List<DynamicGroupSkillCondition> childConditions) {
        this.childConditions = childConditions;
        return this;
    }

    @ApiModelProperty(example="null", value="Nested conditions to be applied to this skill condition")
    @JsonProperty(value="childConditions")
    public List<DynamicGroupSkillCondition> getChildConditions() {
        return this.childConditions;
    }

    public void setChildConditions(List<DynamicGroupSkillCondition> childConditions) {
        this.childConditions = childConditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicGroupLanguageSkillCondition dynamicGroupLanguageSkillCondition = (DynamicGroupLanguageSkillCondition)o;
        return Objects.equals(this.languageSkill, dynamicGroupLanguageSkillCondition.languageSkill) && Objects.equals((Object)this.comparator, (Object)dynamicGroupLanguageSkillCondition.comparator) && Objects.equals(this.proficiency, dynamicGroupLanguageSkillCondition.proficiency) && Objects.equals(this.childConditions, dynamicGroupLanguageSkillCondition.childConditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.languageSkill, this.comparator, this.proficiency, this.childConditions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicGroupLanguageSkillCondition {\n");
        sb.append("    languageSkill: ").append(this.toIndentedString(this.languageSkill)).append("\n");
        sb.append("    comparator: ").append(this.toIndentedString((Object)this.comparator)).append("\n");
        sb.append("    proficiency: ").append(this.toIndentedString(this.proficiency)).append("\n");
        sb.append("    childConditions: ").append(this.toIndentedString(this.childConditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ComparatorEnumDeserializer.class)
    public static enum ComparatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALTO("EqualTo"),
        NOTEQUALTO("NotEqualTo"),
        LESSTHAN("LessThan"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANOREQUALTO("GreaterThanOrEqualTo"),
        LESSTHANOREQUALTO("LessThanOrEqualTo");

        private String value;

        private ComparatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ComparatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ComparatorEnum value : ComparatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ComparatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ComparatorEnumDeserializer
    extends StdDeserializer<ComparatorEnum> {
        public ComparatorEnumDeserializer() {
            super(ComparatorEnumDeserializer.class);
        }

        public ComparatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ComparatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

