/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DecisionTableColumns;
import com.mypurecloud.sdk.v2.model.DecisionTableContract;
import com.mypurecloud.sdk.v2.model.DecisionTableVersionEntity;
import com.mypurecloud.sdk.v2.model.Division;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class DecisionTable
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date datePublished = null;
    private DecisionTableVersionEntity published = null;
    private DecisionTableVersionEntity latest = null;
    private DecisionTableColumns columns = null;
    private DecisionTableContract publishedContract = null;
    private String selfUri = null;

    public DecisionTable() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DecisionTable name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DecisionTable division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public DecisionTable description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The decision table description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePublished")
    public Date getDatePublished() {
        return this.datePublished;
    }

    @ApiModelProperty(example="null", value="The entity reference to the most recently published decision table version. Null if never published.")
    @JsonProperty(value="published")
    public DecisionTableVersionEntity getPublished() {
        return this.published;
    }

    @ApiModelProperty(example="null", value="The entity reference to the most recently created decision table version.")
    @JsonProperty(value="latest")
    public DecisionTableVersionEntity getLatest() {
        return this.latest;
    }

    public DecisionTable columns(DecisionTableColumns columns) {
        this.columns = columns;
        return this;
    }

    @ApiModelProperty(example="null", value="The column definitions of this decision table.")
    @JsonProperty(value="columns")
    public DecisionTableColumns getColumns() {
        return this.columns;
    }

    public void setColumns(DecisionTableColumns columns) {
        this.columns = columns;
    }

    public DecisionTable publishedContract(DecisionTableContract publishedContract) {
        this.publishedContract = publishedContract;
        return this;
    }

    @ApiModelProperty(example="null", value="The published contract information for this decision table.")
    @JsonProperty(value="publishedContract")
    public DecisionTableContract getPublishedContract() {
        return this.publishedContract;
    }

    public void setPublishedContract(DecisionTableContract publishedContract) {
        this.publishedContract = publishedContract;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTable decisionTable = (DecisionTable)o;
        return Objects.equals(this.id, decisionTable.id) && Objects.equals(this.name, decisionTable.name) && Objects.equals(this.division, decisionTable.division) && Objects.equals(this.description, decisionTable.description) && Objects.equals(this.dateCreated, decisionTable.dateCreated) && Objects.equals(this.dateModified, decisionTable.dateModified) && Objects.equals(this.datePublished, decisionTable.datePublished) && Objects.equals(this.published, decisionTable.published) && Objects.equals(this.latest, decisionTable.latest) && Objects.equals(this.columns, decisionTable.columns) && Objects.equals(this.publishedContract, decisionTable.publishedContract) && Objects.equals(this.selfUri, decisionTable.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.division, this.description, this.dateCreated, this.dateModified, this.datePublished, this.published, this.latest, this.columns, this.publishedContract, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    datePublished: ").append(this.toIndentedString(this.datePublished)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    latest: ").append(this.toIndentedString(this.latest)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    publishedContract: ").append(this.toIndentedString(this.publishedContract)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

