/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DailyPossibleShift
implements Serializable {
    private DayOfWeekEnum dayOfWeek = null;
    private Integer earliestShiftStartMinutesFromMidnight = null;
    private Boolean required = null;
    private Integer minimumPaidTimeMinutes = null;
    private Integer maximumPaidTimeMinutes = null;
    private List<Integer> intervalScheduleProbabilities = null;

    public DailyPossibleShift() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.intervalScheduleProbabilities = new ArrayList<Integer>();
        }
    }

    public DailyPossibleShift dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="Day of the shift")
    @JsonProperty(value="dayOfWeek")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public DailyPossibleShift earliestShiftStartMinutesFromMidnight(Integer earliestShiftStartMinutesFromMidnight) {
        this.earliestShiftStartMinutesFromMidnight = earliestShiftStartMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Minutes of the earliest shift start from midnight. Note that midnight is 12:00 am in the time zone specified in the timeZone field (in the top level of the response)")
    @JsonProperty(value="earliestShiftStartMinutesFromMidnight")
    public Integer getEarliestShiftStartMinutesFromMidnight() {
        return this.earliestShiftStartMinutesFromMidnight;
    }

    public void setEarliestShiftStartMinutesFromMidnight(Integer earliestShiftStartMinutesFromMidnight) {
        this.earliestShiftStartMinutesFromMidnight = earliestShiftStartMinutesFromMidnight;
    }

    public DailyPossibleShift required(Boolean required) {
        this.required = required;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a required shift")
    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public DailyPossibleShift minimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum paid time in minutes of this daily shift")
    @JsonProperty(value="minimumPaidTimeMinutes")
    public Integer getMinimumPaidTimeMinutes() {
        return this.minimumPaidTimeMinutes;
    }

    public void setMinimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
    }

    public DailyPossibleShift maximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum paid time in minutes of this daily shift")
    @JsonProperty(value="maximumPaidTimeMinutes")
    public Integer getMaximumPaidTimeMinutes() {
        return this.maximumPaidTimeMinutes;
    }

    public void setMaximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
    }

    public DailyPossibleShift intervalScheduleProbabilities(List<Integer> intervalScheduleProbabilities) {
        this.intervalScheduleProbabilities = intervalScheduleProbabilities;
        return this;
    }

    @ApiModelProperty(example="null", value="The percentage of being scheduled in each interval between the earliest shift start and latest shift end. Range of the values: [0, 100].")
    @JsonProperty(value="intervalScheduleProbabilities")
    public List<Integer> getIntervalScheduleProbabilities() {
        return this.intervalScheduleProbabilities;
    }

    public void setIntervalScheduleProbabilities(List<Integer> intervalScheduleProbabilities) {
        this.intervalScheduleProbabilities = intervalScheduleProbabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyPossibleShift dailyPossibleShift = (DailyPossibleShift)o;
        return Objects.equals((Object)this.dayOfWeek, (Object)dailyPossibleShift.dayOfWeek) && Objects.equals(this.earliestShiftStartMinutesFromMidnight, dailyPossibleShift.earliestShiftStartMinutesFromMidnight) && Objects.equals(this.required, dailyPossibleShift.required) && Objects.equals(this.minimumPaidTimeMinutes, dailyPossibleShift.minimumPaidTimeMinutes) && Objects.equals(this.maximumPaidTimeMinutes, dailyPossibleShift.maximumPaidTimeMinutes) && Objects.equals(this.intervalScheduleProbabilities, dailyPossibleShift.intervalScheduleProbabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayOfWeek, this.earliestShiftStartMinutesFromMidnight, this.required, this.minimumPaidTimeMinutes, this.maximumPaidTimeMinutes, this.intervalScheduleProbabilities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyPossibleShift {\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    earliestShiftStartMinutesFromMidnight: ").append(this.toIndentedString(this.earliestShiftStartMinutesFromMidnight)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    minimumPaidTimeMinutes: ").append(this.toIndentedString(this.minimumPaidTimeMinutes)).append("\n");
        sb.append("    maximumPaidTimeMinutes: ").append(this.toIndentedString(this.maximumPaidTimeMinutes)).append("\n");
        sb.append("    intervalScheduleProbabilities: ").append(this.toIndentedString(this.intervalScheduleProbabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DayOfWeekEnumDeserializer.class)
    public static enum DayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DayOfWeekEnum value : DayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DayOfWeekEnumDeserializer
    extends StdDeserializer<DayOfWeekEnum> {
        public DayOfWeekEnumDeserializer() {
            super(DayOfWeekEnumDeserializer.class);
        }

        public DayOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DayOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

