/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CreateReprocessJobRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private Date dateStart = null;
    private Date dateEnd = null;
    private List<String> programs = null;
    private List<MediaTypesEnum> mediaTypes = null;
    private List<String> dialects = null;

    public CreateReprocessJobRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.programs = new ArrayList<String>();
            this.mediaTypes = new ArrayList<MediaTypesEnum>();
            this.dialects = new ArrayList<String>();
        }
    }

    public CreateReprocessJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name given for the job.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateReprocessJobRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the job.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateReprocessJobRequest dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public CreateReprocessJobRequest dateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The end date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnd")
    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public CreateReprocessJobRequest programs(List<String> programs) {
        this.programs = programs;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of program IDs to filter conversations by.")
    @JsonProperty(value="programs")
    public List<String> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<String> programs) {
        this.programs = programs;
    }

    public CreateReprocessJobRequest mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The types of conversations to reprocess.")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public CreateReprocessJobRequest dialects(List<String> dialects) {
        this.dialects = dialects;
        return this;
    }

    @ApiModelProperty(example="null", value="The dialects to filter by the conversations.")
    @JsonProperty(value="dialects")
    public List<String> getDialects() {
        return this.dialects;
    }

    public void setDialects(List<String> dialects) {
        this.dialects = dialects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReprocessJobRequest createReprocessJobRequest = (CreateReprocessJobRequest)o;
        return Objects.equals(this.name, createReprocessJobRequest.name) && Objects.equals(this.description, createReprocessJobRequest.description) && Objects.equals(this.dateStart, createReprocessJobRequest.dateStart) && Objects.equals(this.dateEnd, createReprocessJobRequest.dateEnd) && Objects.equals(this.programs, createReprocessJobRequest.programs) && Objects.equals(this.mediaTypes, createReprocessJobRequest.mediaTypes) && Objects.equals(this.dialects, createReprocessJobRequest.dialects);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.dateStart, this.dateEnd, this.programs, this.mediaTypes, this.dialects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReprocessJobRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    programs: ").append(this.toIndentedString(this.programs)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    dialects: ").append(this.toIndentedString(this.dialects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CALLBACK("Callback"),
        CHAT("Chat"),
        EMAIL("Email"),
        MESSAGE("Message");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

