/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ScoredAgent;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationRoutingData
implements Serializable {
    private AddressableEntityRef queue = null;
    private AddressableEntityRef language = null;
    private Integer priority = null;
    private List<AddressableEntityRef> skills = null;
    private List<ScoredAgent> scoredAgents = null;
    private String label = null;

    public ConversationRoutingData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.skills = new ArrayList<AddressableEntityRef>();
            this.scoredAgents = new ArrayList<ScoredAgent>();
        }
    }

    public ConversationRoutingData queue(AddressableEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue to use for routing decisions")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(AddressableEntityRef queue) {
        this.queue = queue;
    }

    public ConversationRoutingData language(AddressableEntityRef language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language to use for routing decisions")
    @JsonProperty(value="language")
    public AddressableEntityRef getLanguage() {
        return this.language;
    }

    public void setLanguage(AddressableEntityRef language) {
        this.language = language;
    }

    public ConversationRoutingData priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the conversation to use for routing decisions")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ConversationRoutingData skills(List<AddressableEntityRef> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The skills to use for routing decisions")
    @JsonProperty(value="skills")
    public List<AddressableEntityRef> getSkills() {
        return this.skills;
    }

    public void setSkills(List<AddressableEntityRef> skills) {
        this.skills = skills;
    }

    public ConversationRoutingData scoredAgents(List<ScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="A collection of agents and their assigned scores for this conversation (0 - 100, higher being better), for use in routing to preferred agents")
    @JsonProperty(value="scoredAgents")
    public List<ScoredAgent> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<ScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public ConversationRoutingData label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional label that categorizes the conversation.  Max-utilization settings can be configured at a per-label level")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationRoutingData conversationRoutingData = (ConversationRoutingData)o;
        return Objects.equals(this.queue, conversationRoutingData.queue) && Objects.equals(this.language, conversationRoutingData.language) && Objects.equals(this.priority, conversationRoutingData.priority) && Objects.equals(this.skills, conversationRoutingData.skills) && Objects.equals(this.scoredAgents, conversationRoutingData.scoredAgents) && Objects.equals(this.label, conversationRoutingData.label);
    }

    public int hashCode() {
        return Objects.hash(this.queue, this.language, this.priority, this.skills, this.scoredAgents, this.label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationRoutingData {\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

