/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentDatePicker;
import com.mypurecloud.sdk.v2.model.ConversationContentInput;
import com.mypurecloud.sdk.v2.model.ConversationContentListPicker;
import com.mypurecloud.sdk.v2.model.ConversationContentWheelPicker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Form component element. Examples include: List Picker, Date Picker, Wheel Picker and Input text.")
public class ConversationFormPageComponent
implements Serializable {
    private FormComponentTypeEnum formComponentType = null;
    private ConversationContentDatePicker datePicker = null;
    private ConversationContentWheelPicker wheelPicker = null;
    private ConversationContentListPicker listPicker = null;
    private ConversationContentInput input = null;

    public ConversationFormPageComponent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationFormPageComponent formComponentType(FormComponentTypeEnum formComponentType) {
        this.formComponentType = formComponentType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of this form component element")
    @JsonProperty(value="formComponentType")
    public FormComponentTypeEnum getFormComponentType() {
        return this.formComponentType;
    }

    public void setFormComponentType(FormComponentTypeEnum formComponentType) {
        this.formComponentType = formComponentType;
    }

    public ConversationFormPageComponent datePicker(ConversationContentDatePicker datePicker) {
        this.datePicker = datePicker;
        return this;
    }

    @ApiModelProperty(example="null", value="Date Picker content.")
    @JsonProperty(value="datePicker")
    public ConversationContentDatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(ConversationContentDatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public ConversationFormPageComponent wheelPicker(ConversationContentWheelPicker wheelPicker) {
        this.wheelPicker = wheelPicker;
        return this;
    }

    @ApiModelProperty(example="null", value="Wheel Picker content.")
    @JsonProperty(value="wheelPicker")
    public ConversationContentWheelPicker getWheelPicker() {
        return this.wheelPicker;
    }

    public void setWheelPicker(ConversationContentWheelPicker wheelPicker) {
        this.wheelPicker = wheelPicker;
    }

    public ConversationFormPageComponent listPicker(ConversationContentListPicker listPicker) {
        this.listPicker = listPicker;
        return this;
    }

    @ApiModelProperty(example="null", value="List Picker content.")
    @JsonProperty(value="listPicker")
    public ConversationContentListPicker getListPicker() {
        return this.listPicker;
    }

    public void setListPicker(ConversationContentListPicker listPicker) {
        this.listPicker = listPicker;
    }

    public ConversationFormPageComponent input(ConversationContentInput input) {
        this.input = input;
        return this;
    }

    @ApiModelProperty(example="null", value="Input content.")
    @JsonProperty(value="input")
    public ConversationContentInput getInput() {
        return this.input;
    }

    public void setInput(ConversationContentInput input) {
        this.input = input;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationFormPageComponent conversationFormPageComponent = (ConversationFormPageComponent)o;
        return Objects.equals((Object)this.formComponentType, (Object)conversationFormPageComponent.formComponentType) && Objects.equals(this.datePicker, conversationFormPageComponent.datePicker) && Objects.equals(this.wheelPicker, conversationFormPageComponent.wheelPicker) && Objects.equals(this.listPicker, conversationFormPageComponent.listPicker) && Objects.equals(this.input, conversationFormPageComponent.input);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formComponentType, this.datePicker, this.wheelPicker, this.listPicker, this.input});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationFormPageComponent {\n");
        sb.append("    formComponentType: ").append(this.toIndentedString((Object)this.formComponentType)).append("\n");
        sb.append("    datePicker: ").append(this.toIndentedString(this.datePicker)).append("\n");
        sb.append("    wheelPicker: ").append(this.toIndentedString(this.wheelPicker)).append("\n");
        sb.append("    listPicker: ").append(this.toIndentedString(this.listPicker)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FormComponentTypeEnumDeserializer.class)
    public static enum FormComponentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LISTPICKER("ListPicker"),
        DATEPICKER("DatePicker"),
        WHEELPICKER("WheelPicker"),
        INPUT("Input");

        private String value;

        private FormComponentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FormComponentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FormComponentTypeEnum value : FormComponentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FormComponentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FormComponentTypeEnumDeserializer
    extends StdDeserializer<FormComponentTypeEnum> {
        public FormComponentTypeEnumDeserializer() {
            super(FormComponentTypeEnumDeserializer.class);
        }

        public FormComponentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FormComponentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

