/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConversationContext
implements Serializable {
    private String id = null;
    private ParticipantEnum participant = null;
    private String text = null;

    public ConversationContext() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationContext id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the conversation turn.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationContext participant(ParticipantEnum participant) {
        this.participant = participant;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Participant type of the entity.")
    @JsonProperty(value="participant")
    public ParticipantEnum getParticipant() {
        return this.participant;
    }

    public void setParticipant(ParticipantEnum participant) {
        this.participant = participant;
    }

    public ConversationContext text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The conversation text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContext conversationContext = (ConversationContext)o;
        return Objects.equals(this.id, conversationContext.id) && Objects.equals((Object)this.participant, (Object)conversationContext.participant) && Objects.equals(this.text, conversationContext.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.participant, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContext {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    participant: ").append(this.toIndentedString((Object)this.participant)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ParticipantEnumDeserializer.class)
    public static enum ParticipantEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERNAL("Internal"),
        EXTERNAL("External");

        private String value;

        private ParticipantEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ParticipantEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ParticipantEnum value : ParticipantEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ParticipantEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ParticipantEnumDeserializer
    extends StdDeserializer<ParticipantEnum> {
        public ParticipantEnumDeserializer() {
            super(ParticipantEnumDeserializer.class);
        }

        public ParticipantEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ParticipantEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

