/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CampaignBusinessCategoryMetrics;
import com.mypurecloud.sdk.v2.model.CampaignLinesUtilization;
import com.mypurecloud.sdk.v2.model.ConnectRate;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class CampaignStats
implements Serializable {
    private ConnectRate contactRate = null;
    private Integer idleAgents = null;
    private Double effectiveIdleAgents = null;
    private Double adjustedCallsPerAgent = null;
    private Integer outstandingCalls = null;
    private Integer scheduledCalls = null;
    private Integer timeZoneRescheduledCalls = null;
    private Integer filteredOutContactsCount = null;
    private Integer rightPartyContactsCount = null;
    private Integer validAttempts = null;
    private CampaignLinesUtilization linesUtilization = null;
    private CampaignBusinessCategoryMetrics businessCategoryMetrics = null;

    public CampaignStats() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Information regarding the campaign's connect rate")
    @JsonProperty(value="contactRate")
    public ConnectRate getContactRate() {
        return this.contactRate;
    }

    @ApiModelProperty(example="null", value="Number of available agents not currently being utilized")
    @JsonProperty(value="idleAgents")
    public Integer getIdleAgents() {
        return this.idleAgents;
    }

    @ApiModelProperty(example="null", value="Number of effective available agents not currently being utilized")
    @JsonProperty(value="effectiveIdleAgents")
    public Double getEffectiveIdleAgents() {
        return this.effectiveIdleAgents;
    }

    @ApiModelProperty(example="null", value="Calls per agent adjusted by pace")
    @JsonProperty(value="adjustedCallsPerAgent")
    public Double getAdjustedCallsPerAgent() {
        return this.adjustedCallsPerAgent;
    }

    @ApiModelProperty(example="null", value="Number of campaign calls currently ongoing")
    @JsonProperty(value="outstandingCalls")
    public Integer getOutstandingCalls() {
        return this.outstandingCalls;
    }

    @ApiModelProperty(example="null", value="Number of campaign calls currently scheduled")
    @JsonProperty(value="scheduledCalls")
    public Integer getScheduledCalls() {
        return this.scheduledCalls;
    }

    @ApiModelProperty(example="null", value="Number of campaign calls currently timezone rescheduled")
    @JsonProperty(value="timeZoneRescheduledCalls")
    public Integer getTimeZoneRescheduledCalls() {
        return this.timeZoneRescheduledCalls;
    }

    @ApiModelProperty(example="null", value="Number of contacts that don't match filter. This is currently supported only for Campaigns with dynamic filter on.")
    @JsonProperty(value="filteredOutContactsCount")
    public Integer getFilteredOutContactsCount() {
        return this.filteredOutContactsCount;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's number of Right Party Contacts")
    @JsonProperty(value="rightPartyContactsCount")
    public Integer getRightPartyContactsCount() {
        return this.rightPartyContactsCount;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's valid attempts")
    @JsonProperty(value="validAttempts")
    public Integer getValidAttempts() {
        return this.validAttempts;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's lines utilization")
    @JsonProperty(value="linesUtilization")
    public CampaignLinesUtilization getLinesUtilization() {
        return this.linesUtilization;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's business category metrics")
    @JsonProperty(value="businessCategoryMetrics")
    public CampaignBusinessCategoryMetrics getBusinessCategoryMetrics() {
        return this.businessCategoryMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignStats campaignStats = (CampaignStats)o;
        return Objects.equals(this.contactRate, campaignStats.contactRate) && Objects.equals(this.idleAgents, campaignStats.idleAgents) && Objects.equals(this.effectiveIdleAgents, campaignStats.effectiveIdleAgents) && Objects.equals(this.adjustedCallsPerAgent, campaignStats.adjustedCallsPerAgent) && Objects.equals(this.outstandingCalls, campaignStats.outstandingCalls) && Objects.equals(this.scheduledCalls, campaignStats.scheduledCalls) && Objects.equals(this.timeZoneRescheduledCalls, campaignStats.timeZoneRescheduledCalls) && Objects.equals(this.filteredOutContactsCount, campaignStats.filteredOutContactsCount) && Objects.equals(this.rightPartyContactsCount, campaignStats.rightPartyContactsCount) && Objects.equals(this.validAttempts, campaignStats.validAttempts) && Objects.equals(this.linesUtilization, campaignStats.linesUtilization) && Objects.equals(this.businessCategoryMetrics, campaignStats.businessCategoryMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.contactRate, this.idleAgents, this.effectiveIdleAgents, this.adjustedCallsPerAgent, this.outstandingCalls, this.scheduledCalls, this.timeZoneRescheduledCalls, this.filteredOutContactsCount, this.rightPartyContactsCount, this.validAttempts, this.linesUtilization, this.businessCategoryMetrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignStats {\n");
        sb.append("    contactRate: ").append(this.toIndentedString(this.contactRate)).append("\n");
        sb.append("    idleAgents: ").append(this.toIndentedString(this.idleAgents)).append("\n");
        sb.append("    effectiveIdleAgents: ").append(this.toIndentedString(this.effectiveIdleAgents)).append("\n");
        sb.append("    adjustedCallsPerAgent: ").append(this.toIndentedString(this.adjustedCallsPerAgent)).append("\n");
        sb.append("    outstandingCalls: ").append(this.toIndentedString(this.outstandingCalls)).append("\n");
        sb.append("    scheduledCalls: ").append(this.toIndentedString(this.scheduledCalls)).append("\n");
        sb.append("    timeZoneRescheduledCalls: ").append(this.toIndentedString(this.timeZoneRescheduledCalls)).append("\n");
        sb.append("    filteredOutContactsCount: ").append(this.toIndentedString(this.filteredOutContactsCount)).append("\n");
        sb.append("    rightPartyContactsCount: ").append(this.toIndentedString(this.rightPartyContactsCount)).append("\n");
        sb.append("    validAttempts: ").append(this.toIndentedString(this.validAttempts)).append("\n");
        sb.append("    linesUtilization: ").append(this.toIndentedString(this.linesUtilization)).append("\n");
        sb.append("    businessCategoryMetrics: ").append(this.toIndentedString(this.businessCategoryMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

