/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.CampaignBusinessCategoryMetrics;
import com.mypurecloud.sdk.v2.model.CampaignLinesUtilization;
import com.mypurecloud.sdk.v2.model.CampaignPerformanceDataContactRate;
import com.mypurecloud.sdk.v2.model.CampaignPerformanceDataProgress;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

public class CampaignPerformanceData
implements Serializable {
    private DomainEntityRef campaign = null;
    private AddressableEntityRef division = null;
    private CampaignPerformanceDataContactRate contactRate = null;
    private Integer idleAgents = null;
    private BigDecimal effectiveIdleAgents = null;
    private BigDecimal adjustedCallsPerAgent = null;
    private Integer outstandingCalls = null;
    private Integer scheduledCalls = null;
    private Integer rightPartyContactsCount = null;
    private CampaignStatusEnum campaignStatus = null;
    private DialingModeEnum dialingMode = null;
    private CampaignPerformanceDataProgress progress = null;
    private CampaignLinesUtilization linesUtilization = null;
    private CampaignBusinessCategoryMetrics businessCategoryMetrics = null;

    public CampaignPerformanceData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CampaignPerformanceData campaign(DomainEntityRef campaign) {
        this.campaign = campaign;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier of the campaign")
    @JsonProperty(value="campaign")
    public DomainEntityRef getCampaign() {
        return this.campaign;
    }

    public void setCampaign(DomainEntityRef campaign) {
        this.campaign = campaign;
    }

    public CampaignPerformanceData division(AddressableEntityRef division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division the campaign belongs to")
    @JsonProperty(value="division")
    public AddressableEntityRef getDivision() {
        return this.division;
    }

    public void setDivision(AddressableEntityRef division) {
        this.division = division;
    }

    public CampaignPerformanceData contactRate(CampaignPerformanceDataContactRate contactRate) {
        this.contactRate = contactRate;
        return this;
    }

    @ApiModelProperty(example="null", value="Information regarding the campaign's connect rate")
    @JsonProperty(value="contactRate")
    public CampaignPerformanceDataContactRate getContactRate() {
        return this.contactRate;
    }

    public void setContactRate(CampaignPerformanceDataContactRate contactRate) {
        this.contactRate = contactRate;
    }

    public CampaignPerformanceData idleAgents(Integer idleAgents) {
        this.idleAgents = idleAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of available agents not currently being utilized")
    @JsonProperty(value="idleAgents")
    public Integer getIdleAgents() {
        return this.idleAgents;
    }

    public void setIdleAgents(Integer idleAgents) {
        this.idleAgents = idleAgents;
    }

    public CampaignPerformanceData effectiveIdleAgents(BigDecimal effectiveIdleAgents) {
        this.effectiveIdleAgents = effectiveIdleAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of effective available agents not currently being utilized")
    @JsonProperty(value="effectiveIdleAgents")
    public BigDecimal getEffectiveIdleAgents() {
        return this.effectiveIdleAgents;
    }

    public void setEffectiveIdleAgents(BigDecimal effectiveIdleAgents) {
        this.effectiveIdleAgents = effectiveIdleAgents;
    }

    public CampaignPerformanceData adjustedCallsPerAgent(BigDecimal adjustedCallsPerAgent) {
        this.adjustedCallsPerAgent = adjustedCallsPerAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="Calls per agent adjusted by pace")
    @JsonProperty(value="adjustedCallsPerAgent")
    public BigDecimal getAdjustedCallsPerAgent() {
        return this.adjustedCallsPerAgent;
    }

    public void setAdjustedCallsPerAgent(BigDecimal adjustedCallsPerAgent) {
        this.adjustedCallsPerAgent = adjustedCallsPerAgent;
    }

    public CampaignPerformanceData outstandingCalls(Integer outstandingCalls) {
        this.outstandingCalls = outstandingCalls;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of campaign calls currently ongoing")
    @JsonProperty(value="outstandingCalls")
    public Integer getOutstandingCalls() {
        return this.outstandingCalls;
    }

    public void setOutstandingCalls(Integer outstandingCalls) {
        this.outstandingCalls = outstandingCalls;
    }

    public CampaignPerformanceData scheduledCalls(Integer scheduledCalls) {
        this.scheduledCalls = scheduledCalls;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of campaign calls currently scheduled")
    @JsonProperty(value="scheduledCalls")
    public Integer getScheduledCalls() {
        return this.scheduledCalls;
    }

    public void setScheduledCalls(Integer scheduledCalls) {
        this.scheduledCalls = scheduledCalls;
    }

    public CampaignPerformanceData rightPartyContactsCount(Integer rightPartyContactsCount) {
        this.rightPartyContactsCount = rightPartyContactsCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's number of Right Party Contacts")
    @JsonProperty(value="rightPartyContactsCount")
    public Integer getRightPartyContactsCount() {
        return this.rightPartyContactsCount;
    }

    public void setRightPartyContactsCount(Integer rightPartyContactsCount) {
        this.rightPartyContactsCount = rightPartyContactsCount;
    }

    public CampaignPerformanceData campaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the campaign")
    @JsonProperty(value="campaignStatus")
    public CampaignStatusEnum getCampaignStatus() {
        return this.campaignStatus;
    }

    public void setCampaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
    }

    public CampaignPerformanceData dialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The strategy this Campaign will use for dialing")
    @JsonProperty(value="dialingMode")
    public DialingModeEnum getDialingMode() {
        return this.dialingMode;
    }

    public void setDialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
    }

    public CampaignPerformanceData progress(CampaignPerformanceDataProgress progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's progress")
    @JsonProperty(value="progress")
    public CampaignPerformanceDataProgress getProgress() {
        return this.progress;
    }

    public void setProgress(CampaignPerformanceDataProgress progress) {
        this.progress = progress;
    }

    public CampaignPerformanceData linesUtilization(CampaignLinesUtilization linesUtilization) {
        this.linesUtilization = linesUtilization;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's lines utilization")
    @JsonProperty(value="linesUtilization")
    public CampaignLinesUtilization getLinesUtilization() {
        return this.linesUtilization;
    }

    public void setLinesUtilization(CampaignLinesUtilization linesUtilization) {
        this.linesUtilization = linesUtilization;
    }

    public CampaignPerformanceData businessCategoryMetrics(CampaignBusinessCategoryMetrics businessCategoryMetrics) {
        this.businessCategoryMetrics = businessCategoryMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on the campaign's business category metrics")
    @JsonProperty(value="businessCategoryMetrics")
    public CampaignBusinessCategoryMetrics getBusinessCategoryMetrics() {
        return this.businessCategoryMetrics;
    }

    public void setBusinessCategoryMetrics(CampaignBusinessCategoryMetrics businessCategoryMetrics) {
        this.businessCategoryMetrics = businessCategoryMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignPerformanceData campaignPerformanceData = (CampaignPerformanceData)o;
        return Objects.equals(this.campaign, campaignPerformanceData.campaign) && Objects.equals(this.division, campaignPerformanceData.division) && Objects.equals(this.contactRate, campaignPerformanceData.contactRate) && Objects.equals(this.idleAgents, campaignPerformanceData.idleAgents) && Objects.equals(this.effectiveIdleAgents, campaignPerformanceData.effectiveIdleAgents) && Objects.equals(this.adjustedCallsPerAgent, campaignPerformanceData.adjustedCallsPerAgent) && Objects.equals(this.outstandingCalls, campaignPerformanceData.outstandingCalls) && Objects.equals(this.scheduledCalls, campaignPerformanceData.scheduledCalls) && Objects.equals(this.rightPartyContactsCount, campaignPerformanceData.rightPartyContactsCount) && Objects.equals((Object)this.campaignStatus, (Object)campaignPerformanceData.campaignStatus) && Objects.equals((Object)this.dialingMode, (Object)campaignPerformanceData.dialingMode) && Objects.equals(this.progress, campaignPerformanceData.progress) && Objects.equals(this.linesUtilization, campaignPerformanceData.linesUtilization) && Objects.equals(this.businessCategoryMetrics, campaignPerformanceData.businessCategoryMetrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.campaign, this.division, this.contactRate, this.idleAgents, this.effectiveIdleAgents, this.adjustedCallsPerAgent, this.outstandingCalls, this.scheduledCalls, this.rightPartyContactsCount, this.campaignStatus, this.dialingMode, this.progress, this.linesUtilization, this.businessCategoryMetrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignPerformanceData {\n");
        sb.append("    campaign: ").append(this.toIndentedString(this.campaign)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    contactRate: ").append(this.toIndentedString(this.contactRate)).append("\n");
        sb.append("    idleAgents: ").append(this.toIndentedString(this.idleAgents)).append("\n");
        sb.append("    effectiveIdleAgents: ").append(this.toIndentedString(this.effectiveIdleAgents)).append("\n");
        sb.append("    adjustedCallsPerAgent: ").append(this.toIndentedString(this.adjustedCallsPerAgent)).append("\n");
        sb.append("    outstandingCalls: ").append(this.toIndentedString(this.outstandingCalls)).append("\n");
        sb.append("    scheduledCalls: ").append(this.toIndentedString(this.scheduledCalls)).append("\n");
        sb.append("    rightPartyContactsCount: ").append(this.toIndentedString(this.rightPartyContactsCount)).append("\n");
        sb.append("    campaignStatus: ").append(this.toIndentedString((Object)this.campaignStatus)).append("\n");
        sb.append("    dialingMode: ").append(this.toIndentedString((Object)this.dialingMode)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    linesUtilization: ").append(this.toIndentedString(this.linesUtilization)).append("\n");
        sb.append("    businessCategoryMetrics: ").append(this.toIndentedString(this.businessCategoryMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CampaignStatusEnumDeserializer.class)
    public static enum CampaignStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ON("on"),
        STOPPING("stopping"),
        OFF("off"),
        COMPLETE("complete"),
        INVALID("invalid"),
        FORCED_OFF("forced_off"),
        FORCED_STOPPING("forced_stopping");

        private String value;

        private CampaignStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CampaignStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CampaignStatusEnum value : CampaignStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CampaignStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DialingModeEnumDeserializer.class)
    public static enum DialingModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTLESS("agentless"),
        PREVIEW("preview"),
        POWER("power"),
        PREDICTIVE("predictive"),
        PROGRESSIVE("progressive"),
        EXTERNAL("external");

        private String value;

        private DialingModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DialingModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DialingModeEnum value : DialingModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DialingModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DialingModeEnumDeserializer
    extends StdDeserializer<DialingModeEnum> {
        public DialingModeEnumDeserializer() {
            super(DialingModeEnumDeserializer.class);
        }

        public DialingModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DialingModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class CampaignStatusEnumDeserializer
    extends StdDeserializer<CampaignStatusEnum> {
        public CampaignStatusEnumDeserializer() {
            super(CampaignStatusEnumDeserializer.class);
        }

        public CampaignStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CampaignStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

