/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EntityChange;
import com.mypurecloud.sdk.v2.model.InitiatingAction;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import com.mypurecloud.sdk.v2.model.PropertyChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuditLogMessage
implements Serializable {
    private String id = null;
    private String userHomeOrgId = null;
    private DomainEntityRef user = null;
    private AddressableEntityRef client = null;
    private List<String> remoteIp = null;
    private String serviceName = null;
    private LevelEnum level = null;
    private Date eventDate = null;
    private MessageInfo message = null;
    private String action = null;
    private DomainEntityRef entity = null;
    private String entityType = null;
    private StatusEnum status = null;
    private String application = null;
    private InitiatingAction initiatingAction = null;
    private Boolean transactionInitiator = null;
    private List<PropertyChange> propertyChanges = null;
    private Map<String, String> context = null;
    private List<EntityChange> entityChanges = null;

    public AuditLogMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.remoteIp = new ArrayList<String>();
            this.propertyChanges = new ArrayList<PropertyChange>();
            this.entityChanges = new ArrayList<EntityChange>();
        }
    }

    public AuditLogMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the audit message.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditLogMessage userHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
        return this;
    }

    @ApiModelProperty(example="null", value="Home Organization Id associated with this audit message.")
    @JsonProperty(value="userHomeOrgId")
    public String getUserHomeOrgId() {
        return this.userHomeOrgId;
    }

    public void setUserHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
    }

    public AuditLogMessage user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User associated with this audit message.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public AuditLogMessage client(AddressableEntityRef client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="Client associated with this audit message.")
    @JsonProperty(value="client")
    public AddressableEntityRef getClient() {
        return this.client;
    }

    public void setClient(AddressableEntityRef client) {
        this.client = client;
    }

    public AuditLogMessage remoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
        return this;
    }

    @ApiModelProperty(example="null", value="List of IP addresses of systems that originated or handled the request.")
    @JsonProperty(value="remoteIp")
    public List<String> getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
    }

    public AuditLogMessage serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the service that logged this audit message.")
    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public AuditLogMessage level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(example="null", value="Level of this audit message, USER or SYSTEM.")
    @JsonProperty(value="level")
    public LevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public AuditLogMessage eventDate(Date eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDate")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public AuditLogMessage message(MessageInfo message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="Message describing the event being audited.")
    @JsonProperty(value="message")
    public MessageInfo getMessage() {
        return this.message;
    }

    public void setMessage(MessageInfo message) {
        this.message = message;
    }

    public AuditLogMessage action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="Action that took place.")
    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public AuditLogMessage entity(DomainEntityRef entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", value="Entity that was impacted.")
    @JsonProperty(value="entity")
    public DomainEntityRef getEntity() {
        return this.entity;
    }

    public void setEntity(DomainEntityRef entity) {
        this.entity = entity;
    }

    public AuditLogMessage entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the entity that was impacted.")
    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public AuditLogMessage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the event being audited")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AuditLogMessage application(String application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the application used to perform the audit's action")
    @JsonProperty(value="application")
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public AuditLogMessage initiatingAction(InitiatingAction initiatingAction) {
        this.initiatingAction = initiatingAction;
        return this;
    }

    @ApiModelProperty(example="null", value="Id and action of the audit initiating the transaction")
    @JsonProperty(value="initiatingAction")
    public InitiatingAction getInitiatingAction() {
        return this.initiatingAction;
    }

    public void setInitiatingAction(InitiatingAction initiatingAction) {
        this.initiatingAction = initiatingAction;
    }

    public AuditLogMessage transactionInitiator(Boolean transactionInitiator) {
        this.transactionInitiator = transactionInitiator;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the current audit is the initiator of the transaction")
    @JsonProperty(value="transactionInitiator")
    public Boolean getTransactionInitiator() {
        return this.transactionInitiator;
    }

    public void setTransactionInitiator(Boolean transactionInitiator) {
        this.transactionInitiator = transactionInitiator;
    }

    public AuditLogMessage propertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
        return this;
    }

    @ApiModelProperty(example="null", value="List of properties that were changed and changes made to those properties.")
    @JsonProperty(value="propertyChanges")
    public List<PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void setPropertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
    }

    public AuditLogMessage context(Map<String, String> context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional context for this message.")
    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public AuditLogMessage entityChanges(List<EntityChange> entityChanges) {
        this.entityChanges = entityChanges;
        return this;
    }

    @ApiModelProperty(example="null", value="List of entities that were changed and changes made to those entities.")
    @JsonProperty(value="entityChanges")
    public List<EntityChange> getEntityChanges() {
        return this.entityChanges;
    }

    public void setEntityChanges(List<EntityChange> entityChanges) {
        this.entityChanges = entityChanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogMessage auditLogMessage = (AuditLogMessage)o;
        return Objects.equals(this.id, auditLogMessage.id) && Objects.equals(this.userHomeOrgId, auditLogMessage.userHomeOrgId) && Objects.equals(this.user, auditLogMessage.user) && Objects.equals(this.client, auditLogMessage.client) && Objects.equals(this.remoteIp, auditLogMessage.remoteIp) && Objects.equals(this.serviceName, auditLogMessage.serviceName) && Objects.equals((Object)this.level, (Object)auditLogMessage.level) && Objects.equals(this.eventDate, auditLogMessage.eventDate) && Objects.equals(this.message, auditLogMessage.message) && Objects.equals(this.action, auditLogMessage.action) && Objects.equals(this.entity, auditLogMessage.entity) && Objects.equals(this.entityType, auditLogMessage.entityType) && Objects.equals((Object)this.status, (Object)auditLogMessage.status) && Objects.equals(this.application, auditLogMessage.application) && Objects.equals(this.initiatingAction, auditLogMessage.initiatingAction) && Objects.equals(this.transactionInitiator, auditLogMessage.transactionInitiator) && Objects.equals(this.propertyChanges, auditLogMessage.propertyChanges) && Objects.equals(this.context, auditLogMessage.context) && Objects.equals(this.entityChanges, auditLogMessage.entityChanges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userHomeOrgId, this.user, this.client, this.remoteIp, this.serviceName, this.level, this.eventDate, this.message, this.action, this.entity, this.entityType, this.status, this.application, this.initiatingAction, this.transactionInitiator, this.propertyChanges, this.context, this.entityChanges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userHomeOrgId: ").append(this.toIndentedString(this.userHomeOrgId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    remoteIp: ").append(this.toIndentedString(this.remoteIp)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    initiatingAction: ").append(this.toIndentedString(this.initiatingAction)).append("\n");
        sb.append("    transactionInitiator: ").append(this.toIndentedString(this.transactionInitiator)).append("\n");
        sb.append("    propertyChanges: ").append(this.toIndentedString(this.propertyChanges)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    entityChanges: ").append(this.toIndentedString(this.entityChanges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LevelEnumDeserializer.class)
    public static enum LevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("USER"),
        SYSTEM("SYSTEM"),
        GENESYS_INTERNAL("GENESYS_INTERNAL");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LevelEnum value : LevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE"),
        WARNING("WARNING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LevelEnumDeserializer
    extends StdDeserializer<LevelEnum> {
        public LevelEnumDeserializer() {
            super(LevelEnumDeserializer.class);
        }

        public LevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

