/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssistanceCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnswerOption
implements Serializable {
    private String id = null;
    private String contextId = null;
    private BuiltInTypeEnum builtInType = null;
    private String text = null;
    private Integer value = null;
    private List<AssistanceCondition> assistanceConditions = null;

    public AnswerOption() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.assistanceConditions = new ArrayList<AssistanceCondition>();
        }
    }

    public AnswerOption id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="An identifier for this answer that stays the same across versions of the form.")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    public AnswerOption builtInType(BuiltInTypeEnum builtInType) {
        this.builtInType = builtInType;
        return this;
    }

    @ApiModelProperty(example="null", value="The built-in type of this answer option. Only used for built-in answer options such as selection states for Multiple Select answer options. Possible values include: Selected, Unselected")
    @JsonProperty(value="builtInType")
    public BuiltInTypeEnum getBuiltInType() {
        return this.builtInType;
    }

    public void setBuiltInType(BuiltInTypeEnum builtInType) {
        this.builtInType = builtInType;
    }

    public AnswerOption text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public AnswerOption value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="value")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public AnswerOption assistanceConditions(List<AssistanceCondition> assistanceConditions) {
        this.assistanceConditions = assistanceConditions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of assistance conditions which are combined together with a logical AND operator. Eg ( assistanceCondtion1 && assistanceCondition2 ) wherein assistanceCondition could be ( EXISTS topic1 || topic2 || ... ) or (NOTEXISTS topic3 || topic4 || ...).")
    @JsonProperty(value="assistanceConditions")
    public List<AssistanceCondition> getAssistanceConditions() {
        return this.assistanceConditions;
    }

    public void setAssistanceConditions(List<AssistanceCondition> assistanceConditions) {
        this.assistanceConditions = assistanceConditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnswerOption answerOption = (AnswerOption)o;
        return Objects.equals(this.id, answerOption.id) && Objects.equals(this.contextId, answerOption.contextId) && Objects.equals((Object)this.builtInType, (Object)answerOption.builtInType) && Objects.equals(this.text, answerOption.text) && Objects.equals(this.value, answerOption.value) && Objects.equals(this.assistanceConditions, answerOption.assistanceConditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.contextId, this.builtInType, this.text, this.value, this.assistanceConditions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnswerOption {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    builtInType: ").append(this.toIndentedString((Object)this.builtInType)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    assistanceConditions: ").append(this.toIndentedString(this.assistanceConditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BuiltInTypeEnumDeserializer.class)
    public static enum BuiltInTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SELECTED("Selected"),
        UNSELECTED("Unselected");

        private String value;

        private BuiltInTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BuiltInTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BuiltInTypeEnum value : BuiltInTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BuiltInTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BuiltInTypeEnumDeserializer
    extends StdDeserializer<BuiltInTypeEnum> {
        public BuiltInTypeEnumDeserializer() {
            super(BuiltInTypeEnumDeserializer.class);
        }

        public BuiltInTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BuiltInTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

