/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AlternativeShiftTradeBulkUpdateTemplateItem
implements Serializable {
    private String tradeId = null;
    private StateEnum state = null;
    private FailureReasonEnum failureReason = null;
    private Date adminDateReviewed = null;
    private UserReference adminReviewedBy = null;
    private WfmVersionedEntityMetadata metadata = null;

    public AlternativeShiftTradeBulkUpdateTemplateItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem tradeId(String tradeId) {
        this.tradeId = tradeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of this alternative shift trade")
    @JsonProperty(value="tradeId")
    public String getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current state of this alternative shift trade request")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem failureReason(FailureReasonEnum failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the update failed, if applicable")
    @JsonProperty(value="failureReason")
    public FailureReasonEnum getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(FailureReasonEnum failureReason) {
        this.failureReason = failureReason;
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem adminDateReviewed(Date adminDateReviewed) {
        this.adminDateReviewed = adminDateReviewed;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the trade request was manually reviewed by an admin in ISO-8601 format")
    @JsonProperty(value="adminDateReviewed")
    public Date getAdminDateReviewed() {
        return this.adminDateReviewed;
    }

    public void setAdminDateReviewed(Date adminDateReviewed) {
        this.adminDateReviewed = adminDateReviewed;
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem adminReviewedBy(UserReference adminReviewedBy) {
        this.adminReviewedBy = adminReviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The admin who manually reviewed this alternative shift trade after system denial")
    @JsonProperty(value="adminReviewedBy")
    public UserReference getAdminReviewedBy() {
        return this.adminReviewedBy;
    }

    public void setAdminReviewedBy(UserReference adminReviewedBy) {
        this.adminReviewedBy = adminReviewedBy;
    }

    public AlternativeShiftTradeBulkUpdateTemplateItem metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for this alternative shift trade")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeShiftTradeBulkUpdateTemplateItem alternativeShiftTradeBulkUpdateTemplateItem = (AlternativeShiftTradeBulkUpdateTemplateItem)o;
        return Objects.equals(this.tradeId, alternativeShiftTradeBulkUpdateTemplateItem.tradeId) && Objects.equals((Object)this.state, (Object)alternativeShiftTradeBulkUpdateTemplateItem.state) && Objects.equals((Object)this.failureReason, (Object)alternativeShiftTradeBulkUpdateTemplateItem.failureReason) && Objects.equals(this.adminDateReviewed, alternativeShiftTradeBulkUpdateTemplateItem.adminDateReviewed) && Objects.equals(this.adminReviewedBy, alternativeShiftTradeBulkUpdateTemplateItem.adminReviewedBy) && Objects.equals(this.metadata, alternativeShiftTradeBulkUpdateTemplateItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tradeId, this.state, this.failureReason, this.adminDateReviewed, this.adminReviewedBy, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternativeShiftTradeBulkUpdateTemplateItem {\n");
        sb.append("    tradeId: ").append(this.toIndentedString(this.tradeId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString((Object)this.failureReason)).append("\n");
        sb.append("    adminDateReviewed: ").append(this.toIndentedString(this.adminDateReviewed)).append("\n");
        sb.append("    adminReviewedBy: ").append(this.toIndentedString(this.adminReviewedBy)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CANCELED("Canceled"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        SUBMITTED("Submitted"),
        APPROVED("Approved");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FailureReasonEnumDeserializer.class)
    public static enum FailureReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TRANSITIONNOTALLOWED("TransitionNotAllowed"),
        NOTAUTHORIZED("NotAuthorized");

        private String value;

        private FailureReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FailureReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FailureReasonEnum value : FailureReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FailureReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FailureReasonEnumDeserializer
    extends StdDeserializer<FailureReasonEnum> {
        public FailureReasonEnumDeserializer() {
            super(FailureReasonEnumDeserializer.class);
        }

        public FailureReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FailureReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

