/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ActivityCodeReference;
import com.mypurecloud.sdk.v2.model.ActivityPlanServiceGoalImpactOverrides;
import com.mypurecloud.sdk.v2.model.FixedAvailability;
import com.mypurecloud.sdk.v2.model.GroupSettings;
import com.mypurecloud.sdk.v2.model.ManagementUnitReference;
import com.mypurecloud.sdk.v2.model.RecurrenceSettings;
import com.mypurecloud.sdk.v2.model.SchedulingPeriod;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.UserSearchRule;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ActivityPlanResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private List<ManagementUnitReference> managementUnits = null;
    private String description = null;
    private ActivityCodeReference activityCode = null;
    private TypeEnum type = null;
    private SchedulingPeriod initialSchedulePeriod = null;
    private Integer lengthMinutes = null;
    private GroupSettings groupSettings = null;
    private RecurrenceSettings recurrenceSettings = null;
    private UserSearchRule attendeesSearchRule = null;
    private Boolean facilitated = null;
    private UserSearchRule facilitatorsSearchRule = null;
    private Integer transitionTimeMinutes = null;
    private ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides = null;
    private OptimizationObjectiveEnum optimizationObjective = null;
    private List<FixedAvailability> fixedAvailability = null;
    private StateEnum state = null;
    private Boolean countsAsPaidTime = null;
    private Date createdDate = null;
    private UserReference createdBy = null;
    private Date modifiedDate = null;
    private UserReference modifiedBy = null;
    private Date lastRunDate = null;
    private UserReference lastRunBy = null;
    private String selfUri = null;

    public ActivityPlanResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.managementUnits = new ArrayList<ManagementUnitReference>();
            this.fixedAvailability = new ArrayList<FixedAvailability>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActivityPlanResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the activity plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivityPlanResponse managementUnits(List<ManagementUnitReference> managementUnits) {
        this.managementUnits = managementUnits;
        return this;
    }

    @ApiModelProperty(example="null", value="The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit")
    @JsonProperty(value="managementUnits")
    public List<ManagementUnitReference> getManagementUnits() {
        return this.managementUnits;
    }

    public void setManagementUnits(List<ManagementUnitReference> managementUnits) {
        this.managementUnits = managementUnits;
    }

    public ActivityPlanResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The description of this activity plan")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ActivityPlanResponse activityCode(ActivityCodeReference activityCode) {
        this.activityCode = activityCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity code associated with this activity plan. It is recommended to load and cache the entire list of activity codes rather than look up individual codes")
    @JsonProperty(value="activityCode")
    public ActivityCodeReference getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(ActivityCodeReference activityCode) {
        this.activityCode = activityCode;
    }

    public ActivityPlanResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the activity plan")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ActivityPlanResponse initialSchedulePeriod(SchedulingPeriod initialSchedulePeriod) {
        this.initialSchedulePeriod = initialSchedulePeriod;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The initial schedule period of the activity plan")
    @JsonProperty(value="initialSchedulePeriod")
    public SchedulingPeriod getInitialSchedulePeriod() {
        return this.initialSchedulePeriod;
    }

    public void setInitialSchedulePeriod(SchedulingPeriod initialSchedulePeriod) {
        this.initialSchedulePeriod = initialSchedulePeriod;
    }

    public ActivityPlanResponse lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length of the activity in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public ActivityPlanResponse groupSettings(GroupSettings groupSettings) {
        this.groupSettings = groupSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Group settings for this activity plan")
    @JsonProperty(value="groupSettings")
    public GroupSettings getGroupSettings() {
        return this.groupSettings;
    }

    public void setGroupSettings(GroupSettings groupSettings) {
        this.groupSettings = groupSettings;
    }

    public ActivityPlanResponse recurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Recurrence settings for this activity plan")
    @JsonProperty(value="recurrenceSettings")
    public RecurrenceSettings getRecurrenceSettings() {
        return this.recurrenceSettings;
    }

    public void setRecurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
    }

    public ActivityPlanResponse attendeesSearchRule(UserSearchRule attendeesSearchRule) {
        this.attendeesSearchRule = attendeesSearchRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Attendee search rule for this activity plan")
    @JsonProperty(value="attendeesSearchRule")
    public UserSearchRule getAttendeesSearchRule() {
        return this.attendeesSearchRule;
    }

    public void setAttendeesSearchRule(UserSearchRule attendeesSearchRule) {
        this.attendeesSearchRule = attendeesSearchRule;
    }

    public ActivityPlanResponse facilitated(Boolean facilitated) {
        this.facilitated = facilitated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the sessions created by this activity plan should be facilitated")
    @JsonProperty(value="facilitated")
    public Boolean getFacilitated() {
        return this.facilitated;
    }

    public void setFacilitated(Boolean facilitated) {
        this.facilitated = facilitated;
    }

    public ActivityPlanResponse facilitatorsSearchRule(UserSearchRule facilitatorsSearchRule) {
        this.facilitatorsSearchRule = facilitatorsSearchRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Facilitator search rule for this activity plan")
    @JsonProperty(value="facilitatorsSearchRule")
    public UserSearchRule getFacilitatorsSearchRule() {
        return this.facilitatorsSearchRule;
    }

    public void setFacilitatorsSearchRule(UserSearchRule facilitatorsSearchRule) {
        this.facilitatorsSearchRule = facilitatorsSearchRule;
    }

    public ActivityPlanResponse transitionTimeMinutes(Integer transitionTimeMinutes) {
        this.transitionTimeMinutes = transitionTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Transition time in minutes between facilitated sessions")
    @JsonProperty(value="transitionTimeMinutes")
    public Integer getTransitionTimeMinutes() {
        return this.transitionTimeMinutes;
    }

    public void setTransitionTimeMinutes(Integer transitionTimeMinutes) {
        this.transitionTimeMinutes = transitionTimeMinutes;
    }

    public ActivityPlanResponse serviceGoalImpactOverrides(ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides) {
        this.serviceGoalImpactOverrides = serviceGoalImpactOverrides;
        return this;
    }

    @ApiModelProperty(example="null", value="Allowable service goal impact override settings for this activity plan")
    @JsonProperty(value="serviceGoalImpactOverrides")
    public ActivityPlanServiceGoalImpactOverrides getServiceGoalImpactOverrides() {
        return this.serviceGoalImpactOverrides;
    }

    public void setServiceGoalImpactOverrides(ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides) {
        this.serviceGoalImpactOverrides = serviceGoalImpactOverrides;
    }

    public ActivityPlanResponse optimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The optimization objective of this activity plan")
    @JsonProperty(value="optimizationObjective")
    public OptimizationObjectiveEnum getOptimizationObjective() {
        return this.optimizationObjective;
    }

    public void setOptimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
    }

    public ActivityPlanResponse fixedAvailability(List<FixedAvailability> fixedAvailability) {
        this.fixedAvailability = fixedAvailability;
        return this;
    }

    @ApiModelProperty(example="null", value="Fixed availability configuration for this activity plan")
    @JsonProperty(value="fixedAvailability")
    public List<FixedAvailability> getFixedAvailability() {
        return this.fixedAvailability;
    }

    public void setFixedAvailability(List<FixedAvailability> fixedAvailability) {
        this.fixedAvailability = fixedAvailability;
    }

    public ActivityPlanResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of this activity plan")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ActivityPlanResponse countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the activity should count as paid time")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public ActivityPlanResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the activity plan was created, in ISO-8601 format")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public ActivityPlanResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who created this activity plan")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public ActivityPlanResponse modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the activity plan was modified, in ISO-8601 format")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public ActivityPlanResponse modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The last user to modify this activity plan. The id may be 'System' if it was an automated process")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public ActivityPlanResponse lastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date on which the activity plan was last manually run, in ISO-8601 format")
    @JsonProperty(value="lastRunDate")
    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    public ActivityPlanResponse lastRunBy(UserReference lastRunBy) {
        this.lastRunBy = lastRunBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The last user to run this activity plan")
    @JsonProperty(value="lastRunBy")
    public UserReference getLastRunBy() {
        return this.lastRunBy;
    }

    public void setLastRunBy(UserReference lastRunBy) {
        this.lastRunBy = lastRunBy;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPlanResponse activityPlanResponse = (ActivityPlanResponse)o;
        return Objects.equals(this.id, activityPlanResponse.id) && Objects.equals(this.name, activityPlanResponse.name) && Objects.equals(this.managementUnits, activityPlanResponse.managementUnits) && Objects.equals(this.description, activityPlanResponse.description) && Objects.equals(this.activityCode, activityPlanResponse.activityCode) && Objects.equals((Object)this.type, (Object)activityPlanResponse.type) && Objects.equals(this.initialSchedulePeriod, activityPlanResponse.initialSchedulePeriod) && Objects.equals(this.lengthMinutes, activityPlanResponse.lengthMinutes) && Objects.equals(this.groupSettings, activityPlanResponse.groupSettings) && Objects.equals(this.recurrenceSettings, activityPlanResponse.recurrenceSettings) && Objects.equals(this.attendeesSearchRule, activityPlanResponse.attendeesSearchRule) && Objects.equals(this.facilitated, activityPlanResponse.facilitated) && Objects.equals(this.facilitatorsSearchRule, activityPlanResponse.facilitatorsSearchRule) && Objects.equals(this.transitionTimeMinutes, activityPlanResponse.transitionTimeMinutes) && Objects.equals(this.serviceGoalImpactOverrides, activityPlanResponse.serviceGoalImpactOverrides) && Objects.equals((Object)this.optimizationObjective, (Object)activityPlanResponse.optimizationObjective) && Objects.equals(this.fixedAvailability, activityPlanResponse.fixedAvailability) && Objects.equals((Object)this.state, (Object)activityPlanResponse.state) && Objects.equals(this.countsAsPaidTime, activityPlanResponse.countsAsPaidTime) && Objects.equals(this.createdDate, activityPlanResponse.createdDate) && Objects.equals(this.createdBy, activityPlanResponse.createdBy) && Objects.equals(this.modifiedDate, activityPlanResponse.modifiedDate) && Objects.equals(this.modifiedBy, activityPlanResponse.modifiedBy) && Objects.equals(this.lastRunDate, activityPlanResponse.lastRunDate) && Objects.equals(this.lastRunBy, activityPlanResponse.lastRunBy) && Objects.equals(this.selfUri, activityPlanResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.managementUnits, this.description, this.activityCode, this.type, this.initialSchedulePeriod, this.lengthMinutes, this.groupSettings, this.recurrenceSettings, this.attendeesSearchRule, this.facilitated, this.facilitatorsSearchRule, this.transitionTimeMinutes, this.serviceGoalImpactOverrides, this.optimizationObjective, this.fixedAvailability, this.state, this.countsAsPaidTime, this.createdDate, this.createdBy, this.modifiedDate, this.modifiedBy, this.lastRunDate, this.lastRunBy, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityPlanResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    managementUnits: ").append(this.toIndentedString(this.managementUnits)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    activityCode: ").append(this.toIndentedString(this.activityCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    initialSchedulePeriod: ").append(this.toIndentedString(this.initialSchedulePeriod)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    groupSettings: ").append(this.toIndentedString(this.groupSettings)).append("\n");
        sb.append("    recurrenceSettings: ").append(this.toIndentedString(this.recurrenceSettings)).append("\n");
        sb.append("    attendeesSearchRule: ").append(this.toIndentedString(this.attendeesSearchRule)).append("\n");
        sb.append("    facilitated: ").append(this.toIndentedString(this.facilitated)).append("\n");
        sb.append("    facilitatorsSearchRule: ").append(this.toIndentedString(this.facilitatorsSearchRule)).append("\n");
        sb.append("    transitionTimeMinutes: ").append(this.toIndentedString(this.transitionTimeMinutes)).append("\n");
        sb.append("    serviceGoalImpactOverrides: ").append(this.toIndentedString(this.serviceGoalImpactOverrides)).append("\n");
        sb.append("    optimizationObjective: ").append(this.toIndentedString((Object)this.optimizationObjective)).append("\n");
        sb.append("    fixedAvailability: ").append(this.toIndentedString(this.fixedAvailability)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    lastRunDate: ").append(this.toIndentedString(this.lastRunDate)).append("\n");
        sb.append("    lastRunBy: ").append(this.toIndentedString(this.lastRunBy)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INDIVIDUAL("Individual"),
        GROUP("Group");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OptimizationObjectiveEnumDeserializer.class)
    public static enum OptimizationObjectiveEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAVORSERVICEGOALS("FavorServiceGoals"),
        FAVORSCHEDULINGALL("FavorSchedulingAll");

        private String value;

        private OptimizationObjectiveEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptimizationObjectiveEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptimizationObjectiveEnum value : OptimizationObjectiveEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptimizationObjectiveEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OptimizationObjectiveEnumDeserializer
    extends StdDeserializer<OptimizationObjectiveEnum> {
        public OptimizationObjectiveEnumDeserializer() {
            super(OptimizationObjectiveEnumDeserializer.class);
        }

        public OptimizationObjectiveEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptimizationObjectiveEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

