/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WorkspaceMember;
import java.util.HashMap;
import java.util.Map;

public class PutContentmanagementWorkspaceMemberRequest {
    private String workspaceId;
    private String memberId;
    private WorkspaceMember body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public PutContentmanagementWorkspaceMemberRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public PutContentmanagementWorkspaceMemberRequest withMemberId(String memberId) {
        this.setMemberId(memberId);
        return this;
    }

    public WorkspaceMember getBody() {
        return this.body;
    }

    public void setBody(WorkspaceMember body) {
        this.body = body;
    }

    public PutContentmanagementWorkspaceMemberRequest withBody(WorkspaceMember body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutContentmanagementWorkspaceMemberRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WorkspaceMember> withHttpInfo() {
        if (this.workspaceId == null) {
            throw new IllegalStateException("Missing the required parameter 'workspaceId' when building request for PutContentmanagementWorkspaceMemberRequest.");
        }
        if (this.memberId == null) {
            throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PutContentmanagementWorkspaceMemberRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutContentmanagementWorkspaceMemberRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}").withPathParameter("workspaceId", this.workspaceId).withPathParameter("memberId", this.memberId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String workspaceId, String memberId, WorkspaceMember body) {
        return new Builder().withRequiredParams(workspaceId, memberId, body);
    }

    public static class Builder {
        private final PutContentmanagementWorkspaceMemberRequest request = new PutContentmanagementWorkspaceMemberRequest();

        private Builder() {
        }

        public Builder withWorkspaceId(String workspaceId) {
            this.request.setWorkspaceId(workspaceId);
            return this;
        }

        public Builder withMemberId(String memberId) {
            this.request.setMemberId(memberId);
            return this;
        }

        public Builder withBody(WorkspaceMember body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String workspaceId, String memberId, WorkspaceMember body) {
            this.request.setWorkspaceId(workspaceId);
            this.request.setMemberId(memberId);
            this.request.setBody(body);
            return this;
        }

        public PutContentmanagementWorkspaceMemberRequest build() {
            if (this.request.workspaceId == null) {
                throw new IllegalStateException("Missing the required parameter 'workspaceId' when building request for PutContentmanagementWorkspaceMemberRequest.");
            }
            if (this.request.memberId == null) {
                throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PutContentmanagementWorkspaceMemberRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutContentmanagementWorkspaceMemberRequest.");
            }
            return this.request;
        }
    }
}

