/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningAssignmentStep;
import java.util.HashMap;
import java.util.Map;

public class PatchLearningAssignmentStepRequest {
    private String assignmentId;
    private String stepId;
    private LearningAssignmentStep body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssignmentId() {
        return this.assignmentId;
    }

    public void setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
    }

    public PatchLearningAssignmentStepRequest withAssignmentId(String assignmentId) {
        this.setAssignmentId(assignmentId);
        return this;
    }

    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public PatchLearningAssignmentStepRequest withStepId(String stepId) {
        this.setStepId(stepId);
        return this;
    }

    public LearningAssignmentStep getBody() {
        return this.body;
    }

    public void setBody(LearningAssignmentStep body) {
        this.body = body;
    }

    public PatchLearningAssignmentStepRequest withBody(LearningAssignmentStep body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchLearningAssignmentStepRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningAssignmentStep> withHttpInfo() {
        if (this.assignmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'assignmentId' when building request for PatchLearningAssignmentStepRequest.");
        }
        if (this.stepId == null) {
            throw new IllegalStateException("Missing the required parameter 'stepId' when building request for PatchLearningAssignmentStepRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/learning/assignments/{assignmentId}/steps/{stepId}").withPathParameter("assignmentId", this.assignmentId).withPathParameter("stepId", this.stepId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assignmentId, String stepId) {
        return new Builder().withRequiredParams(assignmentId, stepId);
    }

    public static class Builder {
        private final PatchLearningAssignmentStepRequest request = new PatchLearningAssignmentStepRequest();

        private Builder() {
        }

        public Builder withAssignmentId(String assignmentId) {
            this.request.setAssignmentId(assignmentId);
            return this;
        }

        public Builder withStepId(String stepId) {
            this.request.setStepId(stepId);
            return this;
        }

        public Builder withBody(LearningAssignmentStep body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assignmentId, String stepId) {
            this.request.setAssignmentId(assignmentId);
            this.request.setStepId(stepId);
            return this;
        }

        public PatchLearningAssignmentStepRequest build() {
            if (this.request.assignmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'assignmentId' when building request for PatchLearningAssignmentStepRequest.");
            }
            if (this.request.stepId == null) {
                throw new IllegalStateException("Missing the required parameter 'stepId' when building request for PatchLearningAssignmentStepRequest.");
            }
            return this.request;
        }
    }
}

