/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUsersRuleDependentsRequest {
    private String ruleId;
    private Integer pageSize;
    private Integer pageNumber;
    private String sortOrder;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public GetUsersRuleDependentsRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetUsersRuleDependentsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetUsersRuleDependentsRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public GetUsersRuleDependentsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersRuleDependentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.ruleId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for GetUsersRuleDependentsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/rules/{ruleId}/dependents").withPathParameter("ruleId", this.ruleId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("sortOrder", "", this.sortOrder).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleId) {
        return new Builder().withRequiredParams(ruleId);
    }

    public static class Builder {
        private final GetUsersRuleDependentsRequest request = new GetUsersRuleDependentsRequest();

        private Builder() {
        }

        public Builder withRuleId(String ruleId) {
            this.request.setRuleId(ruleId);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withSortOrder(String sortOrder) {
            this.request.setSortOrder(sortOrder);
            return this;
        }

        public Builder withSortOrder(sortOrderValues sortOrder) {
            this.request.setSortOrder(sortOrder.toString());
            return this;
        }

        public Builder withRequiredParams(String ruleId) {
            this.request.setRuleId(ruleId);
            return this;
        }

        public GetUsersRuleDependentsRequest build() {
            if (this.request.ruleId == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for GetUsersRuleDependentsRequest.");
            }
            return this.request;
        }
    }

    public static enum sortOrderValues {
        ASCENDING("ascending"),
        DESCENDING("descending");

        private String value;

        private sortOrderValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static sortOrderValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (sortOrderValues value : sortOrderValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return sortOrderValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

