/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetGuideJobRequest {
    private String guideId;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGuideId() {
        return this.guideId;
    }

    public void setGuideId(String guideId) {
        this.guideId = guideId;
    }

    public GetGuideJobRequest withGuideId(String guideId) {
        this.setGuideId(guideId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetGuideJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGuideJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.guideId == null) {
            throw new IllegalStateException("Missing the required parameter 'guideId' when building request for GetGuideJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetGuideJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/guides/{guideId}/jobs/{jobId}").withPathParameter("guideId", this.guideId).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String guideId, String jobId) {
        return new Builder().withRequiredParams(guideId, jobId);
    }

    public static class Builder {
        private final GetGuideJobRequest request = new GetGuideJobRequest();

        private Builder() {
        }

        public Builder withGuideId(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String guideId, String jobId) {
            this.request.setGuideId(guideId);
            this.request.setJobId(jobId);
            return this;
        }

        public GetGuideJobRequest build() {
            if (this.request.guideId == null) {
                throw new IllegalStateException("Missing the required parameter 'guideId' when building request for GetGuideJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetGuideJobRequest.");
            }
            return this.request;
        }
    }
}

